/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RenameTable
extends Statement {
    private final QualifiedName source;
    private final QualifiedName target;

    public RenameTable(QualifiedName source, QualifiedName target) {
        this(Optional.empty(), source, target);
    }

    public RenameTable(NodeLocation location, QualifiedName source, QualifiedName target) {
        this(Optional.of(location), source, target);
    }

    private RenameTable(Optional<NodeLocation> location, QualifiedName source, QualifiedName target) {
        super(location);
        this.source = Objects.requireNonNull(source, "source name is null");
        this.target = Objects.requireNonNull(target, "target name is null");
    }

    public QualifiedName getSource() {
        return this.source;
    }

    public QualifiedName getTarget() {
        return this.target;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRenameTable(this, context);
    }

    @Override
    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RenameTable o = (RenameTable)obj;
        return Objects.equals(this.source, o.source) && Objects.equals(this.target, o.target);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).toString();
    }
}

