/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Rollup
extends GroupingElement {
    private final List<QualifiedName> columns;

    public Rollup(List<QualifiedName> columns) {
        this(Optional.empty(), columns);
    }

    public Rollup(NodeLocation location, List<QualifiedName> columns) {
        this(Optional.of(location), columns);
    }

    private Rollup(Optional<NodeLocation> location, List<QualifiedName> columns) {
        super(location);
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    public List<QualifiedName> getColumns() {
        return this.columns;
    }

    @Override
    public List<Set<Expression>> enumerateGroupingSets() {
        int numColumns = this.columns.size();
        return ImmutableList.builder().addAll((Iterable)IntStream.range(0, numColumns).mapToObj(i -> this.columns.subList(0, numColumns - i).stream().map(QualifiedNameReference::new).map(Expression.class::cast).collect(Collectors.toSet())).collect(Collectors.toList())).add((Object)ImmutableSet.of()).build();
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRollup(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollup rollup = (Rollup)o;
        return Objects.equals(this.columns, rollup.columns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).toString();
    }
}

