/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class GroupingSets
extends GroupingElement {
    private final List<List<QualifiedName>> sets;

    public GroupingSets(List<List<QualifiedName>> groupingSetList) {
        this(Optional.empty(), groupingSetList);
    }

    public GroupingSets(NodeLocation location, List<List<QualifiedName>> sets) {
        this(Optional.of(location), sets);
    }

    private GroupingSets(Optional<NodeLocation> location, List<List<QualifiedName>> sets) {
        super(location);
        Objects.requireNonNull(sets);
        Preconditions.checkArgument((!sets.isEmpty() ? 1 : 0) != 0, (Object)"grouping sets cannot be empty");
        this.sets = sets;
    }

    @Override
    public List<Set<Expression>> enumerateGroupingSets() {
        return this.sets.stream().map(groupingSet -> groupingSet.stream().map(QualifiedNameReference::new).collect(Collectors.toSet())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupingSets groupingSets = (GroupingSets)o;
        return Objects.equals(this.sets, groupingSets.sets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sets);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sets", this.sets).toString();
    }
}

