/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.parser;

import com.facebook.presto.sql.parser.AstBuilder;
import com.facebook.presto.sql.parser.CaseInsensitiveStream;
import com.facebook.presto.sql.parser.IdentifierSymbol;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlBaseBaseListener;
import com.facebook.presto.sql.parser.SqlBaseLexer;
import com.facebook.presto.sql.parser.SqlBaseParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class SqlParser {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };
    private final EnumSet<IdentifierSymbol> allowedIdentifierSymbols;

    public SqlParser() {
        this(new SqlParserOptions());
    }

    @Inject
    public SqlParser(SqlParserOptions options) {
        Objects.requireNonNull(options, "options is null");
        this.allowedIdentifierSymbols = EnumSet.copyOf(options.getAllowedIdentifierSymbols());
    }

    public Statement createStatement(String sql) {
        return (Statement)this.invokeParser("statement", sql, SqlBaseParser::singleStatement);
    }

    public Expression createExpression(String expression) {
        return (Expression)this.invokeParser("expression", expression, SqlBaseParser::singleExpression);
    }

    private Node invokeParser(String name, String sql, Function<SqlBaseParser, ParserRuleContext> parseFunction) {
        try {
            ParserRuleContext tree;
            SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)new ANTLRInputStream(sql)));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor());
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parseFunction.apply(parser);
            }
            catch (ParseCancellationException ex) {
                tokenStream.reset();
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parseFunction.apply(parser);
            }
            return (Node)new AstBuilder().visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException(name + " is too large (stack overflow while parsing)");
        }
    }

    private class PostProcessor
    extends SqlBaseBaseListener {
        private PostProcessor() {
        }

        @Override
        public void exitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
            String identifier = context.IDENTIFIER().getText();
            for (IdentifierSymbol identifierSymbol : EnumSet.complementOf(SqlParser.this.allowedIdentifierSymbols)) {
                char symbol = identifierSymbol.getSymbol();
                if (identifier.indexOf(symbol) < 0) continue;
                throw new ParsingException("identifiers must not contain '" + identifierSymbol.getSymbol() + "'", null, context.IDENTIFIER().getSymbol().getLine(), context.IDENTIFIER().getSymbol().getCharPositionInLine());
            }
        }

        @Override
        public void exitBackQuotedIdentifier(SqlBaseParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers are not supported; use double quotes to quote identifiers", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitDigitIdentifier(SqlBaseParser.DigitIdentifierContext context) {
            Token token = context.DIGIT_IDENTIFIER().getSymbol();
            throw new ParsingException("identifiers must not start with a digit; surround the identifier with double quotes", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 187, token.getChannel(), token.getStartIndex() + 1, token.getStopIndex() - 1));
        }

        @Override
        public void exitNonReserved(SqlBaseParser.NonReservedContext context) {
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 187, token.getChannel(), token.getStartIndex(), token.getStopIndex()));
        }
    }
}

