/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.Relation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SampledRelation
extends Relation {
    private final Relation relation;
    private final Type type;
    private final Expression samplePercentage;
    private final boolean rescaled;
    private final Optional<List<Expression>> columnsToStratifyOn;

    public SampledRelation(Relation relation, Type type, Expression samplePercentage, boolean rescaled, Optional<List<Expression>> columnsToStratifyOn) {
        this(Optional.empty(), relation, type, samplePercentage, rescaled, columnsToStratifyOn);
    }

    public SampledRelation(NodeLocation location, Relation relation, Type type, Expression samplePercentage, boolean rescaled, Optional<List<Expression>> columnsToStratifyOn) {
        this(Optional.of(location), relation, type, samplePercentage, rescaled, columnsToStratifyOn);
    }

    private SampledRelation(Optional<NodeLocation> location, Relation relation, Type type, Expression samplePercentage, boolean rescaled, Optional<List<Expression>> columnsToStratifyOn) {
        super(location);
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.samplePercentage = Objects.requireNonNull(samplePercentage, "samplePercentage is null");
        this.rescaled = rescaled;
        this.columnsToStratifyOn = columnsToStratifyOn.isPresent() ? Optional.of(ImmutableList.copyOf((Collection)columnsToStratifyOn.get())) : columnsToStratifyOn;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public Type getType() {
        return this.type;
    }

    public Expression getSamplePercentage() {
        return this.samplePercentage;
    }

    public boolean isRescaled() {
        return this.rescaled;
    }

    public Optional<List<Expression>> getColumnsToStratifyOn() {
        return this.columnsToStratifyOn;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSampledRelation(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relation", (Object)this.relation).add("type", (Object)this.type).add("samplePercentage", (Object)this.samplePercentage).add("columnsToStratifyOn", this.columnsToStratifyOn).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SampledRelation that = (SampledRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.samplePercentage, that.samplePercentage) && Objects.equals(this.columnsToStratifyOn, that.columnsToStratifyOn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.relation, this.type, this.samplePercentage, this.columnsToStratifyOn});
    }

    public static enum Type {
        BERNOULLI,
        POISSONIZED,
        SYSTEM;

    }
}

