/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NodeLocation;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Optional;

public class BinaryLiteral
extends Literal {
    private final Slice value;

    public BinaryLiteral(String value) {
        this(Optional.empty(), value);
    }

    public BinaryLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        String hexString = value.replaceAll("[ \\r\\n\\t]", "").toUpperCase();
        if (hexString.matches(".*[^A-F0-9].*")) {
            throw new ParsingException("Binary literal can only contain hexadecimal digits", location.get());
        }
        if (hexString.length() % 2 != 0) {
            throw new ParsingException("Binary literal must contain an even number of digits", location.get());
        }
        this.value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)hexString));
    }

    public BinaryLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.value.getBytes());
    }

    public Slice getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

