/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.tree;

import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SetOperation;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class Except
extends SetOperation {
    private final Relation left;
    private final Relation right;
    private final boolean distinct;

    public Except(Relation left, Relation right, boolean distinct) {
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.left = left;
        this.right = right;
        this.distinct = distinct;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("left", (Object)this.left).add("right", (Object)this.right).add("distinct", this.distinct).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Except o = (Except)obj;
        return Objects.equals(this.left, o.left) && Objects.equals(this.right, o.right) && Objects.equals(this.distinct, o.distinct);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.distinct);
    }
}

