/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.nativechecker;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.sidecar.NativeSidecarFailureInfo;
import com.facebook.presto.sidecar.nativechecker.NativePlanCheckerErrorCode;
import com.facebook.presto.sidecar.nativechecker.PlanConversionResponse;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanChecker;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.SimplePlanFragment;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public final class NativePlanChecker
implements PlanChecker {
    private static final Logger LOG = Logger.get(NativePlanChecker.class);
    private static final MediaType JSON_CONTENT_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private static final JsonCodec<PlanConversionResponse> PLAN_CONVERSION_RESPONSE_JSON_CODEC = JsonCodec.jsonCodec(PlanConversionResponse.class);
    public static final String PLAN_CONVERSION_ENDPOINT = "/v1/velox/plan";
    private final NodeManager nodeManager;
    private final JsonCodec<SimplePlanFragment> planFragmentJsonCodec;
    private final OkHttpClient httpClient;

    public NativePlanChecker(NodeManager nodeManager, JsonCodec<SimplePlanFragment> planFragmentJsonCodec) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.planFragmentJsonCodec = Objects.requireNonNull(planFragmentJsonCodec, "planFragmentJsonCodec is null");
        this.httpClient = new OkHttpClient.Builder().build();
    }

    public void validate(PlanNode planNode, WarningCollector warningCollector, ConnectorSession session) {
    }

    public void validateFragment(SimplePlanFragment planFragment, WarningCollector warningCollector, ConnectorSession session) {
        if (planFragment.getPartitioning().isCoordinatorOnly() || this.isInternalSystemConnector(planFragment.getRoot())) {
            LOG.debug("Skipping native plan validation [fragment: %s, root: %s]", new Object[]{planFragment.getId(), planFragment.getRoot().getId()});
            return;
        }
        this.runValidation(this.removeTableWriter(planFragment));
    }

    private SimplePlanFragment removeTableWriter(SimplePlanFragment planFragment) {
        PlanNode root = (PlanNode)planFragment.getRoot().accept((PlanVisitor)new TableWriterNodeReplacer(), null);
        Objects.requireNonNull(root, "TableWriterNode removal resulted in null root");
        return new SimplePlanFragment(planFragment.getId(), root, planFragment.getVariables(), planFragment.getPartitioning(), planFragment.getTableScanSchedulingOrder(), planFragment.getPartitioningScheme(), planFragment.getStageExecutionDescriptor(), planFragment.isOutputTableWriterFragment());
    }

    private boolean isInternalSystemConnector(PlanNode planNode) {
        return (Boolean)planNode.accept((PlanVisitor)new CheckInternalVisitor(), null);
    }

    private void runValidation(SimplePlanFragment planFragment) {
        LOG.debug("Starting native plan validation [fragment: %s, root: %s]", new Object[]{planFragment.getId(), planFragment.getRoot().getId()});
        String requestBodyJson = this.planFragmentJsonCodec.toJson((Object)planFragment);
        Request request = this.buildRequest(requestBodyJson);
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                NativeSidecarFailureInfo failure = this.processResponseFailure(response);
                String message = String.format("Error from native plan checker: %s", MoreObjects.firstNonNull((Object)failure.getMessage(), (Object)"Internal error"));
                throw new PrestoException(failure::getErrorCode, message, (Throwable)failure.toException());
            }
        }
        catch (IOException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)NativePlanCheckerErrorCode.NATIVEPLANCHECKER_CONNECTION_ERROR, "I/O error getting native plan checker response", (Throwable)e);
            }
            catch (Throwable throwable) {
                LOG.debug("Native plan validation complete [fragment: %s, root: %s]", new Object[]{planFragment.getId(), planFragment.getRoot().getId()});
                throw throwable;
            }
        }
        LOG.debug("Native plan validation complete [fragment: %s, root: %s]", new Object[]{planFragment.getId(), planFragment.getRoot().getId()});
    }

    private Request buildRequest(String requestBodyJson) {
        String planConversionUrl = this.nodeManager.getSidecarNode().getHttpUri().toString() + PLAN_CONVERSION_ENDPOINT;
        Request.Builder builder = new Request.Builder().url(planConversionUrl).addHeader("CONTENT_TYPE", "APPLICATION_JSON").post(RequestBody.create((MediaType)JSON_CONTENT_TYPE, (String)requestBodyJson));
        return builder.build();
    }

    private NativeSidecarFailureInfo processResponseFailure(Response response) throws IOException {
        if (response.body() == null) {
            throw new PrestoException((ErrorCodeSupplier)NativePlanCheckerErrorCode.NATIVEPLANCHECKER_UNKNOWN_CONVERSION_FAILURE, "Error response without failure from native plan checker with code: " + response.code());
        }
        PlanConversionResponse planConversionResponse = (PlanConversionResponse)PLAN_CONVERSION_RESPONSE_JSON_CODEC.fromJson(response.body().bytes());
        if (planConversionResponse.getFailures().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)NativePlanCheckerErrorCode.NATIVEPLANCHECKER_UNKNOWN_CONVERSION_FAILURE, "Error response without failure from native plan checker with code: " + response.code());
        }
        return planConversionResponse.getFailures().get(0);
    }

    private static class TableWriterNodeReplacer
    extends PlanVisitor<PlanNode, Void> {
        private TableWriterNodeReplacer() {
        }

        public PlanNode visitTableWriter(TableWriterNode tableWriter, Void context) {
            Map<VariableReferenceExpression, RowExpression> assignmentsMap = tableWriter.getOutputVariables().subList(3, tableWriter.getOutputVariables().size()).stream().collect(Collectors.toMap(i -> i, i -> i));
            assignmentsMap.put(tableWriter.getRowCountVariable(), (RowExpression)new ConstantExpression((Object)0L, (Type)BigintType.BIGINT));
            assignmentsMap.put(tableWriter.getFragmentVariable(), (RowExpression)new ConstantExpression((Object)Slices.utf8Slice((String)""), (Type)VarcharType.VARCHAR));
            assignmentsMap.put(tableWriter.getTableCommitContextVariable(), (RowExpression)new ConstantExpression((Object)Slices.utf8Slice((String)""), (Type)VarcharType.VARCHAR));
            Assignments assignments = Assignments.builder().putAll(assignmentsMap).build();
            return new ProjectNode(tableWriter.getId(), tableWriter.getSource(), Assignments.builder().putAll(assignmentsMap).build());
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            List prunedChildren = (List)node.getSources().stream().map(child -> (PlanNode)child.accept((PlanVisitor)this, (Object)context)).collect(ImmutableList.toImmutableList());
            return node.replaceChildren(prunedChildren);
        }
    }

    private static class CheckInternalVisitor
    extends PlanVisitor<Boolean, Void> {
        private CheckInternalVisitor() {
        }

        public Boolean visitTableScan(TableScanNode tableScan, Void context) {
            TableHandle handle = tableScan.getTable();
            return ConnectorId.isInternalSystemConnector((ConnectorId)handle.getConnectorId());
        }

        public Boolean visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                if (!((Boolean)child.accept((PlanVisitor)this, (Object)context)).booleanValue()) continue;
                return true;
            }
            return false;
        }
    }
}

