/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.builtin.tools.NativeSidecarFunctionRegistryTool;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.sidecar.ForSidecarInfo;
import com.facebook.presto.sidecar.functionNamespace.FunctionDefinitionProvider;
import com.facebook.presto.sidecar.functionNamespace.NativeFunctionNamespaceManagerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NativeFunctionDefinitionProvider
implements FunctionDefinitionProvider {
    private static final Logger log = Logger.get(NativeFunctionDefinitionProvider.class);
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec;
    private final HttpClient httpClient;
    private final NativeFunctionNamespaceManagerConfig config;
    private final String catalogName;

    @Inject
    public NativeFunctionDefinitionProvider(@ForSidecarInfo HttpClient httpClient, JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec, NativeFunctionNamespaceManagerConfig config, @ServingCatalog String catalogName) {
        this.nativeFunctionSignatureMapJsonCodec = Objects.requireNonNull(nativeFunctionSignatureMapJsonCodec, "nativeFunctionSignatureMapJsonCodec is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.config = Objects.requireNonNull(config, "config is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    @Override
    public UdfFunctionSignatureMap getUdfDefinition(NodeManager nodeManager) {
        try {
            URI baseUri = NativeSidecarFunctionRegistryTool.getSidecarLocationOnStartup((NodeManager)nodeManager, (int)this.config.getSidecarNumRetries(), (long)this.config.getSidecarRetryDelay().toMillis());
            URI catalogUri = HttpUriBuilder.uriBuilderFrom((URI)baseUri).appendPath(this.catalogName).build();
            Request catalogRequest = Request.Builder.prepareGet().setUri(catalogUri).build();
            Map nativeFunctionSignatureMap = (Map)this.httpClient.execute(catalogRequest, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.nativeFunctionSignatureMapJsonCodec));
            return new UdfFunctionSignatureMap((Map)ImmutableMap.copyOf((Map)nativeFunctionSignatureMap));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Failed to get catalog-scoped functions from sidecar for catalog '%s'", this.catalogName), (Throwable)e);
        }
    }

    @VisibleForTesting
    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

