/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.builtin.tools.NativeSidecarFunctionRegistryTool;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.sidecar.ForSidecarInfo;
import com.facebook.presto.sidecar.functionNamespace.FunctionDefinitionProvider;
import com.facebook.presto.sidecar.functionNamespace.NativeFunctionNamespaceManagerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NativeFunctionDefinitionProvider
implements FunctionDefinitionProvider {
    private static final Logger log = Logger.get(NativeFunctionDefinitionProvider.class);
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec;
    private final HttpClient httpClient;
    private final NativeFunctionNamespaceManagerConfig config;

    @Inject
    public NativeFunctionDefinitionProvider(@ForSidecarInfo HttpClient httpClient, JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec, NativeFunctionNamespaceManagerConfig config) {
        this.nativeFunctionSignatureMapJsonCodec = Objects.requireNonNull(nativeFunctionSignatureMapJsonCodec, "nativeFunctionSignatureMapJsonCodec is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @Override
    public UdfFunctionSignatureMap getUdfDefinition(NodeManager nodeManager) {
        try {
            Request request = Request.Builder.prepareGet().setUri(NativeSidecarFunctionRegistryTool.getSidecarLocationOnStartup((NodeManager)nodeManager, (int)this.config.getSidecarNumRetries(), (long)this.config.getSidecarRetryDelay().toMillis())).build();
            Map nativeFunctionSignatureMap = (Map)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.nativeFunctionSignatureMapJsonCodec));
            return new UdfFunctionSignatureMap((Map)ImmutableMap.copyOf((Map)nativeFunctionSignatureMap));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Failed to get functions from sidecar.", (Throwable)e);
        }
    }

    @VisibleForTesting
    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

