/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sidecar.functionNamespace;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.functionNamespace.JsonBasedUdfFunctionMetadata;
import com.facebook.presto.functionNamespace.UdfFunctionSignatureMap;
import com.facebook.presto.sidecar.ForSidecarInfo;
import com.facebook.presto.sidecar.functionNamespace.FunctionDefinitionProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NativeFunctionDefinitionProvider
implements FunctionDefinitionProvider {
    private static final Logger log = Logger.get(NativeFunctionDefinitionProvider.class);
    private final JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec;
    private final NodeManager nodeManager;
    private final HttpClient httpClient;
    private static final String FUNCTION_SIGNATURES_ENDPOINT = "/v1/functions";

    @Inject
    public NativeFunctionDefinitionProvider(@ForSidecarInfo HttpClient httpClient, JsonCodec<Map<String, List<JsonBasedUdfFunctionMetadata>>> nativeFunctionSignatureMapJsonCodec, NodeManager nodeManager) {
        this.nativeFunctionSignatureMapJsonCodec = Objects.requireNonNull(nativeFunctionSignatureMapJsonCodec, "nativeFunctionSignatureMapJsonCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.httpClient = Objects.requireNonNull(httpClient, "typeManager is null");
    }

    @Override
    public UdfFunctionSignatureMap getUdfDefinition(NodeManager nodeManager) {
        try {
            Request request = Request.Builder.prepareGet().setUri(this.getSidecarLocation()).build();
            Map nativeFunctionSignatureMap = (Map)this.httpClient.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.nativeFunctionSignatureMapJsonCodec));
            return new UdfFunctionSignatureMap((Map)ImmutableMap.copyOf((Map)nativeFunctionSignatureMap));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, "Failed to get functions from sidecar.", (Throwable)e);
        }
    }

    private URI getSidecarLocation() {
        Node sidecarNode = this.nodeManager.getSidecarNode();
        return HttpUriBuilder.uriBuilderFrom((URI)sidecarNode.getHttpUri()).appendPath(FUNCTION_SIGNATURES_ENDPOINT).build();
    }
}

