/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateTimeEncoding;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.NamedTypeSignature;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.ObjectIdType;
import com.facebook.presto.mongodb.TypeUtils;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertManyOptions;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bson.BsonInvalidOperationException;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MongoPageSink
implements ConnectorPageSink {
    private final MongoSession mongoSession;
    private final ConnectorSession session;
    private final SchemaTableName schemaTableName;
    private final List<MongoColumnHandle> columns;
    private final String implicitPrefix;

    public MongoPageSink(MongoClientConfig config, MongoSession mongoSession, ConnectorSession session, SchemaTableName schemaTableName, List<MongoColumnHandle> columns) {
        this.mongoSession = mongoSession;
        this.session = session;
        this.schemaTableName = schemaTableName;
        this.columns = columns;
        this.implicitPrefix = config.getImplicitRowFieldPrefix();
    }

    public CompletableFuture<?> appendPage(Page page) {
        MongoCollection<Document> collection = this.mongoSession.getCollection(this.schemaTableName);
        ArrayList<Document> batch = new ArrayList<Document>(page.getPositionCount());
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Document doc = new Document();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                MongoColumnHandle column = this.columns.get(channel);
                doc.append(column.getName(), this.getObjectValue(this.columns.get(channel).getType(), page.getBlock(channel), position));
            }
            batch.add(doc);
        }
        collection.insertMany(batch, new InsertManyOptions().ordered(true));
        return NOT_BLOCKED;
    }

    private Object getObjectValue(Type type, Block block, int position) {
        if (block.isNull(position)) {
            if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
                return new ObjectId();
            }
            return null;
        }
        if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            return new ObjectId(block.getSlice(position, 0, block.getSliceLength(position)).getBytes());
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return type.getBoolean(block, position);
        }
        if (type.equals(BigintType.BIGINT)) {
            return type.getLong(block, position);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return (int)type.getLong(block, position);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return (short)type.getLong(block, position);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return (byte)type.getLong(block, position);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return type.getDouble(block, position);
        }
        if (Varchars.isVarcharType((Type)type)) {
            return type.getSlice(block, position).toStringUtf8();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return new Binary(type.getSlice(block, position).getBytes());
        }
        if (type.equals(DateType.DATE)) {
            long days = type.getLong(block, position);
            return new Date(TimeUnit.DAYS.toMillis(days));
        }
        if (type.equals(TimeType.TIME)) {
            long millisUtc = type.getLong(block, position);
            return new Date(millisUtc);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            long millisUtc = type.getLong(block, position);
            return new Date(millisUtc);
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)type.getLong(block, position));
            return new Date(millisUtc);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigInteger unscaledValue = decimalType.isShort() ? BigInteger.valueOf(decimalType.getLong(block, position)) : Decimals.decodeUnscaledValue((Slice)decimalType.getSlice(block, position));
            return new BigDecimal(unscaledValue);
        }
        if (TypeUtils.isJsonType(type)) {
            String json = type.getSlice(block, position).toStringUtf8();
            try {
                return Document.parse((String)json);
            }
            catch (BsonInvalidOperationException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can't convert json to MongoDB Document: " + json, (Throwable)e);
            }
        }
        if (TypeUtils.isArrayType(type)) {
            Type elementType = (Type)type.getTypeParameters().get(0);
            Block arrayBlock = block.getBlock(position);
            ArrayList<Object> list = new ArrayList<Object>(arrayBlock.getPositionCount());
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                Object element = this.getObjectValue(elementType, arrayBlock, i);
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (TypeUtils.isMapType(type)) {
            Type keyType = (Type)type.getTypeParameters().get(0);
            Type valueType = (Type)type.getTypeParameters().get(1);
            Block mapBlock = block.getBlock(position);
            ArrayList values = new ArrayList(mapBlock.getPositionCount() / 2);
            for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
                HashMap<String, Object> mapValue = new HashMap<String, Object>();
                mapValue.put("key", this.getObjectValue(keyType, mapBlock, i));
                mapValue.put("value", this.getObjectValue(valueType, mapBlock, i + 1));
                values.add(mapValue);
            }
            return Collections.unmodifiableList(values);
        }
        if (TypeUtils.isRowType(type)) {
            Block rowBlock = block.getBlock(position);
            List fieldTypes = type.getTypeParameters();
            if (fieldTypes.size() != rowBlock.getPositionCount()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expected row value field count does not match type field count");
            }
            if (this.isImplicitRowType(type)) {
                ArrayList<Object> rowValue = new ArrayList<Object>();
                for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                    Object element = this.getObjectValue((Type)fieldTypes.get(i), rowBlock, i);
                    rowValue.add(element);
                }
                return Collections.unmodifiableList(rowValue);
            }
            HashMap<String, Object> rowValue = new HashMap<String, Object>();
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                rowValue.put(((TypeSignatureParameter)type.getTypeSignature().getParameters().get(i)).getNamedTypeSignature().getName().orElse("field" + i), this.getObjectValue((Type)fieldTypes.get(i), rowBlock, i));
            }
            return Collections.unmodifiableMap(rowValue);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    private boolean isImplicitRowType(Type type) {
        return type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).filter(Optional::isPresent).map(Optional::get).allMatch(name -> name.startsWith(this.implicitPrefix));
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

