/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoInsertTableHandle;
import com.facebook.presto.mongodb.MongoOutputTableHandle;
import com.facebook.presto.mongodb.MongoPageSink;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkProperties;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import javax.inject.Inject;

public class MongoPageSinkProvider
implements ConnectorPageSinkProvider {
    private final MongoClientConfig config;
    private final MongoSession mongoSession;

    @Inject
    public MongoPageSinkProvider(MongoClientConfig config, MongoSession mongoSession) {
        this.config = config;
        this.mongoSession = mongoSession;
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, PageSinkProperties pageSinkProperties) {
        Preconditions.checkArgument((!pageSinkProperties.isCommitRequired() ? 1 : 0) != 0, (Object)"Mongo connector does not support page sink commit");
        MongoOutputTableHandle handle = (MongoOutputTableHandle)outputTableHandle;
        return new MongoPageSink(this.config, this.mongoSession, session, handle.getSchemaTableName(), handle.getColumns());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, PageSinkProperties pageSinkProperties) {
        Preconditions.checkArgument((!pageSinkProperties.isCommitRequired() ? 1 : 0) != 0, (Object)"Mongo connector does not support page sink commit");
        MongoInsertTableHandle handle = (MongoInsertTableHandle)insertTableHandle;
        return new MongoPageSink(this.config, this.mongoSession, session, handle.getSchemaTableName(), handle.getColumns());
    }
}

