/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.bson.Document;

public class MongoColumnHandle
implements ColumnHandle {
    public static final String SAMPLE_WEIGHT_COLUMN_NAME = "presto_sample_weight";
    private final String name;
    private final Type type;
    private final boolean hidden;

    @JsonCreator
    public MongoColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="columnType") Type type, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "columnType is null");
        this.hidden = hidden;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="columnType")
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.name, this.type, null, this.hidden);
    }

    public Document getDocument() {
        return new Document().append("name", (Object)this.name).append("type", (Object)this.type.getTypeSignature().toString()).append("hidden", (Object)this.hidden);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoColumnHandle other = (MongoColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.hidden, other.hidden);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("hidden", this.hidden).toString();
    }
}

