/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoSplit;
import com.facebook.presto.mongodb.MongoTableHandle;
import com.facebook.presto.mongodb.MongoTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class MongoSplitManager
implements ConnectorSplitManager {
    private final List<HostAddress> addresses;

    @Inject
    public MongoSplitManager(MongoClientConfig config) {
        this.addresses = config.getSeeds().stream().map(s -> HostAddress.fromParts((String)s.getHost(), (int)s.getPort())).collect(Collectors.toList());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout) {
        MongoTableLayoutHandle tableLayout = (MongoTableLayoutHandle)layout;
        MongoTableHandle tableHandle = tableLayout.getTable();
        MongoSplit split = new MongoSplit(tableHandle.getSchemaTableName(), tableLayout.getTupleDomain(), this.addresses);
        return new FixedSplitSource((Iterable)ImmutableList.of((Object)split));
    }
}

