/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoInsertTableHandle;
import com.facebook.presto.mongodb.MongoOutputTableHandle;
import com.facebook.presto.mongodb.MongoPageSink;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import javax.inject.Inject;

public class MongoPageSinkProvider
implements ConnectorPageSinkProvider {
    private final MongoClientConfig config;
    private final MongoSession mongoSession;

    @Inject
    public MongoPageSinkProvider(MongoClientConfig config, MongoSession mongoSession) {
        this.config = config;
        this.mongoSession = mongoSession;
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        MongoOutputTableHandle handle = (MongoOutputTableHandle)outputTableHandle;
        return new MongoPageSink(this.config, this.mongoSession, session, handle.getSchemaTableName(), handle.getColumns());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        MongoInsertTableHandle handle = (MongoInsertTableHandle)insertTableHandle;
        return new MongoPageSink(this.config, this.mongoSession, session, handle.getSchemaTableName(), handle.getColumns());
    }
}

