/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MongoSplit
implements ConnectorSplit {
    private final String connectorId;
    private final SchemaTableName schemaTableName;
    private final TupleDomain<ColumnHandle> tupleDomain;
    private final List<HostAddress> addresses;

    @JsonCreator
    public MongoSplit(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="tupleDomain") TupleDomain<ColumnHandle> tupleDomain, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.connectorId = Objects.requireNonNull(connectorId, "connector id is null");
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getTupleDomain() {
        return this.tupleDomain;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

