/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.mongodb.MongoConnectorFactory;
import com.facebook.presto.mongodb.MongoFunctionFactory;
import com.facebook.presto.mongodb.ObjectIdType;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class MongoPlugin
implements Plugin {
    private Map<String, String> optionalConfig = ImmutableMap.of();
    private TypeManager typeManager;

    public void setOptionalConfig(Map<String, String> optionalConfig) {
        this.optionalConfig = ImmutableMap.copyOf(Objects.requireNonNull(optionalConfig, "optionalConfig is null"));
    }

    @Inject
    public synchronized void setTypeManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public <T> List<T> getServices(Class<T> type) {
        if (type == ConnectorFactory.class) {
            return ImmutableList.of(type.cast(new MongoConnectorFactory("mongodb", this.typeManager, this.optionalConfig)));
        }
        if (type == Type.class) {
            return ImmutableList.of(type.cast((Object)ObjectIdType.OBJECT_ID));
        }
        if (type == FunctionFactory.class) {
            return ImmutableList.of(type.cast(new MongoFunctionFactory()));
        }
        return ImmutableList.of();
    }
}

