/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientModule;
import com.facebook.presto.mongodb.MongoConnector;
import com.facebook.presto.mongodb.MongoConnectorId;
import com.facebook.presto.mongodb.MongoHandleResolver;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import java.util.Map;
import java.util.Objects;

public class MongoConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final Map<String, String> optionalConfig;
    private final TypeManager typeManager;

    public MongoConnectorFactory(String name, TypeManager typeManager, Map<String, String> optionalConfig) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.optionalConfig = Objects.requireNonNull(optionalConfig, "optionalConfig is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new MongoHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config) {
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MongoClientModule(), binder -> {
                binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
                binder.bind(MongoConnectorId.class).toInstance((Object)new MongoConnectorId(connectorId));
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).setOptionalConfigurationProperties(this.optionalConfig).initialize();
            return (Connector)injector.getInstance(MongoConnector.class);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

