/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoMetadata;
import com.facebook.presto.mongodb.MongoPageSinkProvider;
import com.facebook.presto.mongodb.MongoPageSourceProvider;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.MongoSplitManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorPageSinkProvider;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import java.util.Objects;
import javax.inject.Inject;

public class MongoConnector
implements Connector {
    private final MongoSession mongoSession;
    private final MongoMetadata metadata;
    private final MongoSplitManager splitManager;
    private final MongoPageSourceProvider pageSourceProvider;
    private final MongoPageSinkProvider pageSinkProvider;

    @Inject
    public MongoConnector(MongoSession mongoSession, MongoMetadata metadata, MongoSplitManager splitManager, MongoPageSourceProvider pageSourceProvider, MongoPageSinkProvider pageSinkProvider) {
        this.mongoSession = mongoSession;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
    }

    public ConnectorMetadata getMetadata() {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public void shutdown() {
        this.mongoSession.shutdown();
    }
}

