/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.mongodb;

import com.facebook.presto.mongodb.MongoClientConfig;
import com.facebook.presto.mongodb.MongoColumnHandle;
import com.facebook.presto.mongodb.MongoSession;
import com.facebook.presto.mongodb.ObjectIdType;
import com.facebook.presto.mongodb.TypeUtils;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.InsertManyOptions;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class MongoPageSink
implements ConnectorPageSink {
    private final MongoSession mongoSession;
    private final ConnectorSession session;
    private final SchemaTableName schemaTableName;
    private final List<MongoColumnHandle> columns;
    private final List<Boolean> requireTranslate;
    private final String implicitPrefix;

    public MongoPageSink(MongoClientConfig config, MongoSession mongoSession, ConnectorSession session, SchemaTableName schemaTableName, List<MongoColumnHandle> columns) {
        this.mongoSession = mongoSession;
        this.session = session;
        this.schemaTableName = schemaTableName;
        this.columns = columns;
        this.requireTranslate = columns.stream().map(c -> {
            Predicate[] predicateArray = new Predicate[4];
            predicateArray[0] = TypeUtils::isMapType;
            predicateArray[1] = TypeUtils::isRowType;
            predicateArray[2] = arg_0 -> ((ObjectIdType)ObjectIdType.OBJECT_ID).equals(arg_0);
            predicateArray[3] = arg_0 -> ((VarbinaryType)VarbinaryType.VARBINARY).equals(arg_0);
            return TypeUtils.containsType(c.getType(), TypeUtils::isDateType, predicateArray);
        }).collect(Collectors.toList());
        this.implicitPrefix = config.getImplicitRowFieldPrefix();
    }

    public CompletableFuture<?> appendPage(Page page, Block sampleWeightBlock) {
        MongoCollection<Document> collection = this.mongoSession.getCollection(this.schemaTableName);
        ArrayList<Document> batch = new ArrayList<Document>(page.getPositionCount());
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Document doc = new Document();
            for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                MongoColumnHandle column = this.columns.get(channel);
                doc.append(column.getName(), this.getObjectValue(this.columns.get(channel).getType(), page.getBlock(channel), position, this.requireTranslate.get(channel)));
            }
            batch.add(doc);
        }
        collection.insertMany(batch, new InsertManyOptions().ordered(true));
        return NOT_BLOCKED;
    }

    private Object getObjectValue(Type type, Block block, int position, boolean translate) {
        if (block.isNull(position)) {
            return null;
        }
        Object value = type.getObjectValue(this.session, block, position);
        if (translate) {
            value = this.translateValue(type, value);
        }
        return value;
    }

    private Object translateValue(Type type, Object value) {
        if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            ObjectId objectId = value = value == null ? new ObjectId() : new ObjectId(((SqlVarbinary)value).getBytes());
        }
        if (value == null) {
            return null;
        }
        if (type.getJavaType() == Long.TYPE) {
            if (value instanceof SqlDate) {
                return new Date(TimeUnit.DAYS.toMillis(((SqlDate)value).getDays()));
            }
            if (value instanceof SqlTime) {
                return new Date(((SqlTime)value).getMillisUtc());
            }
            if (value instanceof SqlTimestamp) {
                return new Date(((SqlTimestamp)value).getMillisUtc());
            }
            if (value instanceof SqlTimestampWithTimeZone) {
                return new Date(((SqlTimestampWithTimeZone)value).getMillisUtc());
            }
        } else if (type.getJavaType() == Slice.class) {
            if (type.equals(VarbinaryType.VARBINARY)) {
                value = new Binary(((SqlVarbinary)value).getBytes());
            }
        } else if (type.getJavaType() == Block.class) {
            if (TypeUtils.isArrayType(type)) {
                value = ((List)value).stream().map(v -> this.translateValue((Type)type.getTypeParameters().get(0), v)).collect(Collectors.toList());
            } else if (TypeUtils.isMapType(type)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    HashMap<String, Object> mapValue = new HashMap<String, Object>();
                    mapValue.put("key", this.translateValue((Type)type.getTypeParameters().get(0), entry.getKey()));
                    mapValue.put("value", this.translateValue((Type)type.getTypeParameters().get(1), entry.getValue()));
                    builder.add(mapValue);
                }
                value = builder.build();
            } else if (TypeUtils.isRowType(type)) {
                List fieldValues = (List)value;
                if (this.isImplicitRowType(type)) {
                    ArrayList<Object> rowValue = new ArrayList<Object>();
                    for (int index = 0; index < fieldValues.size(); ++index) {
                        rowValue.add(this.translateValue((Type)type.getTypeParameters().get(index), fieldValues.get(index)));
                    }
                    value = rowValue;
                } else {
                    HashMap<String, Object> rowValue = new HashMap<String, Object>();
                    for (int index = 0; index < fieldValues.size(); ++index) {
                        rowValue.put(((TypeSignatureParameter)type.getTypeSignature().getParameters().get(index)).getNamedTypeSignature().getName(), this.translateValue((Type)type.getTypeParameters().get(index), fieldValues.get(index)));
                    }
                    value = rowValue;
                }
            }
        }
        return value;
    }

    private boolean isImplicitRowType(Type type) {
        return type.getTypeSignature().getParameters().stream().map(TypeSignatureParameter::getNamedTypeSignature).map(NamedTypeSignature::getName).allMatch(name -> name.startsWith(this.implicitPrefix));
    }

    public Collection<Slice> finish() {
        return ImmutableList.of();
    }

    public void abort() {
    }
}

