/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Classifier;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.Model;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.Regressor;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Types;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.HashMap;

public final class MLFunctions {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Cache<HashCode, Model> MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(5L).build();
    private static final String MAP_BIGINT_DOUBLE = "map<bigint,double>";

    private MLFunctions() {
    }

    @ScalarFunction(value="classify")
    @SqlType(value="varchar")
    public static Slice varcharClassify(@SqlType(value="map<bigint,double>") Slice featuresMap, @SqlType(value="Classifier<varchar>") Slice modelSlice) {
        FeatureVector features = ModelUtils.jsonToFeatures(featuresMap);
        Model model = MLFunctions.getOrLoadModel(modelSlice);
        Preconditions.checkArgument((boolean)model.getType().equals((Object)ClassifierType.VARCHAR_CLASSIFIER), (Object)"model is not a classifier<varchar>");
        Classifier varcharClassifier = (Classifier)Types.checkType((Object)model, Classifier.class, (String)"model");
        return Slices.utf8Slice((String)((String)varcharClassifier.classify(features)));
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long classify(@SqlType(value="map<bigint,double>") Slice featuresMap, @SqlType(value="Classifier<bigint>") Slice modelSlice) {
        FeatureVector features = ModelUtils.jsonToFeatures(featuresMap);
        Model model = MLFunctions.getOrLoadModel(modelSlice);
        Preconditions.checkArgument((boolean)model.getType().equals((Object)ClassifierType.BIGINT_CLASSIFIER), (Object)"model is not a classifier<bigint>");
        Classifier classifier = (Classifier)Types.checkType((Object)model, Classifier.class, (String)"model");
        return ((Integer)classifier.classify(features)).intValue();
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double regress(@SqlType(value="map<bigint,double>") Slice featuresMap, @SqlType(value="Regressor") Slice modelSlice) {
        FeatureVector features = ModelUtils.jsonToFeatures(featuresMap);
        Model model = MLFunctions.getOrLoadModel(modelSlice);
        Preconditions.checkArgument((boolean)model.getType().equals((Object)RegressorType.REGRESSOR), (Object)"model is not a regressor");
        Regressor regressor = (Regressor)Types.checkType((Object)model, Regressor.class, (String)"model");
        return regressor.regress(features);
    }

    private static Model getOrLoadModel(Slice slice) {
        HashCode modelHash = ModelUtils.modelHash(slice);
        Model model = (Model)MODEL_CACHE.getIfPresent((Object)modelHash);
        if (model == null) {
            model = ModelUtils.deserialize(slice);
            MODEL_CACHE.put((Object)modelHash, (Object)model);
        }
        return model;
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1) {
        return MLFunctions.featuresHelper(f1);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2) {
        return MLFunctions.featuresHelper(f1, f2);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3) {
        return MLFunctions.featuresHelper(f1, f2, f3);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    @ScalarFunction
    @SqlType(value="map<bigint,double>")
    public static Slice features(@SqlType(value="double") double f1, @SqlType(value="double") double f2, @SqlType(value="double") double f3, @SqlType(value="double") double f4, @SqlType(value="double") double f5, @SqlType(value="double") double f6, @SqlType(value="double") double f7, @SqlType(value="double") double f8, @SqlType(value="double") double f9, @SqlType(value="double") double f10) {
        return MLFunctions.featuresHelper(f1, f2, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    private static Slice featuresHelper(double ... features) {
        HashMap<Integer, Double> featureMap = new HashMap<Integer, Double>();
        for (int i = 0; i < features.length; ++i) {
            featureMap.put(i, features[i]);
        }
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(featureMap));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

