/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureUnitNormalizer;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LearnState;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.RegressorFeatureTransformer;
import com.facebook.presto.ml.SvmRegressor;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;

@AggregationFunction(value="learn_libsvm_regressor", decomposable=false)
public final class LearnLibSvmRegressorAggregation {
    private LearnLibSvmRegressorAggregation() {
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="bigint") long label, @SqlType(value="map<bigint,double>") Slice features, @SqlType(value="varchar") Slice parameters) {
        LearnLibSvmRegressorAggregation.input(state, (double)label, features, parameters);
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="double") double label, @SqlType(value="map<bigint,double>") Slice features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(label);
        FeatureVector featureVector = ModelUtils.jsonToFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(LibSvmUtils.parseParameters(parameters.toStringUtf8()));
    }

    @CombineFunction
    public static void combine(LearnState state, LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Regressor")
    public static void output(LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors());
        RegressorFeatureTransformer model = new RegressorFeatureTransformer(new SvmRegressor(state.getParameters()), new FeatureUnitNormalizer());
        model.train(dataset);
        RegressorType.REGRESSOR.writeSlice(out, ModelUtils.serialize(model));
    }
}

