/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VariableWidthType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.util.List;

public class ModelType
implements VariableWidthType {
    public static final ModelType MODEL = new ModelType();

    @JsonCreator
    public ModelType() {
    }

    public String getName() {
        return "Model";
    }

    public boolean isComparable() {
        return false;
    }

    public boolean isOrderable() {
        return false;
    }

    public Class<?> getJavaType() {
        return Slice.class;
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.of();
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(String.format("%s type is not comparable", this.getName()));
    }

    public int hash(Block block, int position) {
        throw new UnsupportedOperationException(String.format("%s type is not comparable", this.getName()));
    }

    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(String.format("%s type is not ordered", this.getName()));
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void writeBoolean(BlockBuilder sliceOutput, boolean value) {
        throw new UnsupportedOperationException();
    }

    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void writeLong(BlockBuilder sliceOutput, long value) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void writeDouble(BlockBuilder sliceOutput, double value) {
        throw new UnsupportedOperationException();
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return String.format("<%s>", this.getName());
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(blockBuilderStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

