/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.AbstractSvmModel;
import com.facebook.presto.ml.Classifier;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.type.ClassifierType;
import com.facebook.presto.ml.type.ModelType;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;

public class SvmClassifier
extends AbstractSvmModel
implements Classifier<Integer> {
    public SvmClassifier() {
        this(LibSvmUtils.parseParameters(""));
    }

    public SvmClassifier(svm_parameter params) {
        super(params);
    }

    private SvmClassifier(svm_model model) {
        super(model);
    }

    public static SvmClassifier deserialize(byte[] modelData) {
        try {
            svm_model model = svm.svm_load_model((BufferedReader)new BufferedReader(new InputStreamReader(new ByteArrayInputStream(modelData))));
            return new SvmClassifier(model);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Integer classify(FeatureVector features) {
        Objects.requireNonNull(this.model, "model is null");
        return (int)svm.svm_predict((svm_model)this.model, (svm_node[])SvmClassifier.toSvmNodes(features));
    }

    @Override
    public ModelType getType() {
        return ClassifierType.BIGINT_CLASSIFIER;
    }

    @Override
    protected int getLibsvmType() {
        return 0;
    }
}

