/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureUnitNormalizer;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.LearnState;
import com.facebook.presto.ml.LibSvmUtils;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.RegressorFeatureTransformer;
import com.facebook.presto.ml.SvmRegressor;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import java.util.Map;

@AggregationFunction(value="learn_libsvm_regressor", decomposable=false)
public final class LearnLibSvmRegressorAggregation {
    private LearnLibSvmRegressorAggregation() {
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="bigint") long label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        LearnLibSvmRegressorAggregation.input(state, (double)label, features, parameters);
    }

    @InputFunction
    public static void input(LearnState state, @SqlType(value="double") double label, @SqlType(value="map(bigint,double)") Block features, @SqlType(value="varchar") Slice parameters) {
        state.getLabels().add(label);
        FeatureVector featureVector = ModelUtils.toFeatures(features);
        state.addMemoryUsage(featureVector.getEstimatedSize());
        state.getFeatureVectors().add(featureVector);
        state.setParameters(parameters);
    }

    @CombineFunction
    public static void combine(LearnState state, LearnState otherState) {
        throw new UnsupportedOperationException("LEARN must run on a single machine");
    }

    @OutputFunction(value="Regressor")
    public static void output(LearnState state, BlockBuilder out) {
        Dataset dataset = new Dataset(state.getLabels(), state.getFeatureVectors(), (Map<Integer, String>)state.getLabelEnumeration().inverse());
        RegressorFeatureTransformer model = new RegressorFeatureTransformer(new SvmRegressor(LibSvmUtils.parseParameters(state.getParameters().toStringUtf8())), new FeatureUnitNormalizer());
        model.train(dataset);
        RegressorType.REGRESSOR.writeSlice(out, ModelUtils.serialize(model));
    }
}

