/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.ml;

import com.facebook.presto.ml.Dataset;
import com.facebook.presto.ml.FeatureTransformation;
import com.facebook.presto.ml.FeatureVector;
import com.facebook.presto.ml.Model;
import com.facebook.presto.ml.ModelUtils;
import com.facebook.presto.ml.Regressor;
import com.facebook.presto.ml.type.ModelType;
import com.facebook.presto.ml.type.RegressorType;
import com.facebook.presto.util.Types;
import java.util.List;
import java.util.Objects;

public class RegressorFeatureTransformer
implements Regressor {
    private final Regressor regressor;
    private final FeatureTransformation transformation;

    public RegressorFeatureTransformer(Regressor regressor, FeatureTransformation transformation) {
        this.regressor = Objects.requireNonNull(regressor, "regressor is null");
        this.transformation = Objects.requireNonNull(transformation, "transformation is null");
    }

    @Override
    public ModelType getType() {
        return RegressorType.REGRESSOR;
    }

    @Override
    public byte[] getSerializedData() {
        return ModelUtils.serializeModels(this.regressor, this.transformation);
    }

    public static RegressorFeatureTransformer deserialize(byte[] data) {
        List<Model> models = ModelUtils.deserializeModels(data);
        return new RegressorFeatureTransformer((Regressor)Types.checkType((Object)models.get(0), Regressor.class, (String)"model 0"), (FeatureTransformation)Types.checkType((Object)models.get(1), FeatureTransformation.class, (String)"model 1"));
    }

    @Override
    public double regress(FeatureVector features) {
        return this.regressor.regress(this.transformation.transform(features));
    }

    @Override
    public void train(Dataset dataset) {
        this.transformation.train(dataset);
        this.regressor.train(this.transformation.transform(dataset));
    }
}

