/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.memory;

import com.facebook.presto.plugin.memory.MemoryColumnHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MemoryTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final Long tableId;
    private final List<MemoryColumnHandle> columnHandles;
    private final List<HostAddress> hosts;

    public MemoryTableHandle(String connectorId, Long tableId, ConnectorTableMetadata tableMetadata, List<HostAddress> hosts) {
        this(connectorId, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), tableId, MemoryColumnHandle.extractColumnHandles(tableMetadata.getColumns()), hosts);
    }

    @JsonCreator
    public MemoryTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="tableId") Long tableId, @JsonProperty(value="columnHandles") List<MemoryColumnHandle> columnHandles, @JsonProperty(value="hosts") List<HostAddress> hosts) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableId = Objects.requireNonNull(tableId, "tableId is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.hosts = Objects.requireNonNull(hosts, "hosts is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Long getTableId() {
        return this.tableId;
    }

    @JsonProperty
    public List<MemoryColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public List<HostAddress> getHosts() {
        return this.hosts;
    }

    public ConnectorTableMetadata toTableMetadata() {
        return new ConnectorTableMetadata(this.toSchemaTableName(), this.columnHandles.stream().map(MemoryColumnHandle::toColumnMetadata).collect(Collectors.toList()));
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.getConnectorId(), this.getTableId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryTableHandle other = (MemoryTableHandle)obj;
        return Objects.equals(this.getConnectorId(), other.getConnectorId()) && Objects.equals(this.getTableId(), other.getTableId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("tableId", (Object)this.tableId).add("columnHandles", this.columnHandles).toString();
    }
}

