/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.MemoryReservationHandler;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

class RootAggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final MemoryReservationHandler reservationHandler;
    private final long guaranteedMemory;

    RootAggregatedMemoryContext(MemoryReservationHandler reservationHandler, long guaranteedMemory) {
        this.reservationHandler = Objects.requireNonNull(reservationHandler, "reservationHandler is null");
        this.guaranteedMemory = guaranteedMemory;
    }

    @Override
    synchronized ListenableFuture<?> updateBytes(long bytes) {
        ListenableFuture future = this.reservationHandler.reserveMemory(bytes);
        this.addBytes(bytes);
        if (this.getBytes() < this.guaranteedMemory) {
            future = NOT_BLOCKED;
        }
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(long delta) {
        if (this.reservationHandler.tryReserveMemory(delta)) {
            this.addBytes(delta);
            return true;
        }
        return false;
    }

    @Override
    synchronized AbstractAggregatedMemoryContext getParent() {
        return null;
    }

    @Override
    void closeContext() {
        this.reservationHandler.reserveMemory(-this.getBytes());
    }
}

