/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.AbstractAggregatedMemoryContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;

class ChildAggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final AbstractAggregatedMemoryContext parentMemoryContext;

    ChildAggregatedMemoryContext(AggregatedMemoryContext parentMemoryContext) {
        Verify.verify((boolean)(parentMemoryContext instanceof AbstractAggregatedMemoryContext));
        this.parentMemoryContext = (AbstractAggregatedMemoryContext)Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    @Override
    synchronized ListenableFuture<?> updateBytes(long bytes) {
        ListenableFuture<?> future = this.parentMemoryContext.updateBytes(bytes);
        this.addBytes(bytes);
        return future;
    }

    @Override
    synchronized boolean tryUpdateBytes(long delta) {
        if (this.parentMemoryContext.tryUpdateBytes(delta)) {
            this.addBytes(delta);
            return true;
        }
        return false;
    }

    @Override
    synchronized AbstractAggregatedMemoryContext getParent() {
        return this.parentMemoryContext;
    }

    @Override
    void closeContext() {
        this.parentMemoryContext.updateBytes(-this.getBytes());
    }
}

