/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory.context;

import com.facebook.presto.memory.context.ChildAggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.memory.context.MemoryReservationHandler;
import com.facebook.presto.memory.context.RootAggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleAggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatedMemoryContext {
    static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    @GuardedBy(value="this")
    private long usedBytes;
    @GuardedBy(value="this")
    private boolean closed;

    public static AggregatedMemoryContext newSimpleAggregatedMemoryContext() {
        return new SimpleAggregatedMemoryContext();
    }

    public AggregatedMemoryContext newAggregatedMemoryContext() {
        return new ChildAggregatedMemoryContext(this);
    }

    public static AggregatedMemoryContext newRootAggregatedMemoryContext(MemoryReservationHandler reservationHandler, long guaranteedMemoryInBytes) {
        return new RootAggregatedMemoryContext(reservationHandler, guaranteedMemoryInBytes);
    }

    public LocalMemoryContext newLocalMemoryContext() {
        return new SimpleLocalMemoryContext(this);
    }

    public synchronized long getBytes() {
        return this.usedBytes;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeContext();
        this.usedBytes = 0L;
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.usedBytes).add("closed", this.closed).toString();
    }

    synchronized void addBytes(long bytes) {
        this.usedBytes = AggregatedMemoryContext.addExact(this.usedBytes, bytes);
    }

    abstract ListenableFuture<?> updateBytes(long var1);

    abstract boolean tryUpdateBytes(long var1);

    @Nullable
    abstract AggregatedMemoryContext getParent();

    abstract void closeContext();

    static long addExact(long usedBytes, long bytes) {
        try {
            return Math.addExact(usedBytes, bytes);
        }
        catch (ArithmeticException e) {
            throw new RuntimeException(String.format("Overflow detected. usedBytes: %d, bytes: %d", usedBytes, bytes), e);
        }
    }
}

