/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;

public final class TypeJsonUtils {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private TypeJsonUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object stackRepresentationToObject(ConnectorSession session, Slice value, Type type) {
        if (value == null) {
            return null;
        }
        try (JsonParser jsonParser = JSON_FACTORY.createJsonParser((InputStream)value.getInput());){
            jsonParser.nextToken();
            Object object = TypeJsonUtils.stackRepresentationToObjectHelper(session, jsonParser, type);
            return object;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Object stackRepresentationToObjectHelper(ConnectorSession session, JsonParser parser, Type type) throws IOException {
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayList<Object> list = new ArrayList<Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (Object)"Expected a json array");
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                list.add(TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((ArrayType)type).getElementType()));
            }
            return Collections.unmodifiableList(list);
        }
        if (type instanceof MapType) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (Object)"Expected a json object");
            while (parser.nextValue() != JsonToken.END_OBJECT) {
                Object key = TypeJsonUtils.mapKeyToObject(session, parser.getCurrentName(), ((MapType)type).getKeyType());
                Object value = TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((MapType)type).getValueType());
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, parser.getBooleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, parser.getLongValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, parser.getDoubleValue());
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)parser.getValueAsString()));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    private static Object mapKeyToObject(ConnectorSession session, String jsonKey, Type type) {
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, Boolean.valueOf(jsonKey).booleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, Long.valueOf(jsonKey).longValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, Double.valueOf(jsonKey).doubleValue());
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)jsonKey));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }
}

