/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.RawSliceSerializer;
import com.facebook.presto.type.TypeJsonUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapType
extends AbstractVariableWidthType {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new SliceSerializer()));
    private static final ObjectMapper RAW_SLICE_OBJECT_MAPPER = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Slice.class, (JsonSerializer)new RawSliceSerializer()));
    private final Type keyType;
    private final Type valueType;

    public MapType(Type keyType, Type valueType) {
        super(String.format("map<%s,%s>", keyType, valueType), Slice.class);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static Slice toStackRepresentation(Map<?, ?> value) {
        try {
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                if (entry.getKey() instanceof Slice) {
                    map.put(((Slice)entry.getKey()).toStringUtf8(), entry.getValue());
                    continue;
                }
                map.put(entry.getKey().toString(), entry.getValue());
            }
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(map));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Slice rawValueSlicesToStackRepresentation(Map<?, ?> value) {
        try {
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry<?, ?> entry : value.entrySet()) {
                if (entry.getKey() instanceof Slice) {
                    map.put(((Slice)entry.getKey()).toStringUtf8(), entry.getValue());
                    continue;
                }
                map.put(entry.getKey().toString(), entry.getValue());
            }
            return Slices.utf8Slice((String)RAW_SLICE_OBJECT_MAPPER.writeValueAsString(map));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getLength(position));
        return TypeJsonUtils.stackRepresentationToObject(session, slice, (Type)this);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(blockBuilderStatus);
    }

    public List<Type> getTypeParameters() {
        return ImmutableList.of((Object)this.getKeyType(), (Object)this.getValueType());
    }
}

