/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.ParametricType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class MapParametricType
implements ParametricType {
    public static final MapParametricType MAP = new MapParametricType();
    private static final Set<Type> SUPPORTED_KEY_TYPES = ImmutableSet.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)DateType.DATE, (Object)TimestampType.TIMESTAMP, (Object[])new Type[0]);

    private MapParametricType() {
    }

    @Override
    public String getName() {
        return "map";
    }

    public MapType createType(List<Type> types) {
        Preconditions.checkArgument((types.size() == 2 ? 1 : 0) != 0, (Object)"Expected two types");
        Preconditions.checkArgument((boolean)SUPPORTED_KEY_TYPES.contains(types.get(0)), (String)"Unsupported key type; %s", (Object[])new Object[]{types.get(0)});
        return new MapType(types.get(0), types.get(1));
    }
}

