/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.VariableWidthBlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class JsonType
extends AbstractVariableWidthType {
    public static final JsonType JSON = new JsonType();

    public JsonType() {
        super("json", Slice.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getSlice(position, 0, block.getLength(position)).toStringUtf8();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getLength(position));
    }

    public void writeString(BlockBuilder blockBuilder, String value) {
        this.writeSlice(blockBuilder, Slices.utf8Slice((String)value));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus) {
        return new VariableWidthBlockBuilder(blockBuilderStatus);
    }
}

