/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractFixedWidthType;

public class ColorType
extends AbstractFixedWidthType {
    public static final ColorType COLOR = new ColorType();
    public static final String NAME = "color";

    private ColorType() {
        super(NAME, Long.TYPE, 4);
    }

    public boolean isComparable() {
        return true;
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int color = block.getInt(position, 0);
        if (color < 0) {
            return ColorFunctions.SystemColor.valueOf(-(color + 1)).getName();
        }
        return String.format("#%02x%02x%02x", color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int rightValue;
        int leftValue = leftBlock.getInt(leftPosition, 0);
        return leftValue == (rightValue = rightBlock.getInt(rightPosition, 0));
    }

    public int hash(Block block, int position) {
        return block.getInt(position, 0);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeInt(block.getInt(position, 0)).closeEntry();
        }
    }

    public long getLong(Block block, int position) {
        return block.getInt(position, 0);
    }

    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeInt((int)value).closeEntry();
    }
}

