/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableCommitNode
extends PlanNode {
    private final PlanNode source;
    private final TableWriterNode.WriterTarget target;
    private final List<Symbol> outputs;

    @JsonCreator
    public TableCommitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") TableWriterNode.WriterTarget target, @JsonProperty(value="outputs") List<Symbol> outputs) {
        super(id);
        Preconditions.checkArgument((target != null || source instanceof TableWriterNode ? 1 : 0) != 0);
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.target = (TableWriterNode.WriterTarget)Preconditions.checkNotNull((Object)target, (Object)"target is null");
        this.outputs = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputs, (Object)"outputs is null")));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public TableWriterNode.WriterTarget getTarget() {
        return this.target;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableCommit(this, context);
    }
}

