/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.InputReference;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SymbolToInputRewriter
extends ExpressionRewriter<Void> {
    private final Map<Symbol, Integer> symbolToChannelMapping;

    public SymbolToInputRewriter(Map<Symbol, Integer> symbolToChannelMapping) {
        Preconditions.checkNotNull(symbolToChannelMapping, (Object)"symbolToChannelMapping is null");
        this.symbolToChannelMapping = ImmutableMap.copyOf(symbolToChannelMapping);
    }

    public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
        Integer channel = this.symbolToChannelMapping.get(Symbol.fromQualifiedName(node.getName()));
        Preconditions.checkArgument((channel != null ? 1 : 0) != 0, (String)"Cannot resolve symbol %s", (Object[])new Object[]{node.getName()});
        return new InputReference(channel.intValue());
    }
}

