/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.util.IterableTransformer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final PlanDistribution distribution;
    private final PlanNodeId partitionedSource;
    private final List<Type> types;
    private final List<PlanNode> sources;
    private final Set<PlanNodeId> sourceIds;
    private final OutputPartitioning outputPartitioning;
    private final List<Symbol> partitionBy;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="distribution") PlanDistribution distribution, @JsonProperty(value="partitionedSource") PlanNodeId partitionedSource, @JsonProperty(value="outputPartitioning") OutputPartitioning outputPartitioning, @JsonProperty(value="partitionBy") List<Symbol> partitionBy) {
        this.id = (PlanFragmentId)Preconditions.checkNotNull((Object)id, (Object)"id is null");
        this.root = (PlanNode)Preconditions.checkNotNull((Object)root, (Object)"root is null");
        this.symbols = (Map)Preconditions.checkNotNull(symbols, (Object)"symbols is null");
        this.distribution = (PlanDistribution)((Object)Preconditions.checkNotNull((Object)((Object)distribution), (Object)"distribution is null"));
        this.partitionedSource = partitionedSource;
        this.partitionBy = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null")));
        this.types = ImmutableList.copyOf(IterableTransformer.on(root.getOutputSymbols()).transform(Functions.forMap(symbols)).list());
        ImmutableList.Builder sources = ImmutableList.builder();
        PlanFragment.findSources(root, (ImmutableList.Builder<PlanNode>)sources, partitionedSource);
        this.sources = sources.build();
        ImmutableSet.Builder sourceIds = ImmutableSet.builder();
        for (PlanNode source : this.sources) {
            sourceIds.add((Object)source.getId());
        }
        if (partitionedSource != null) {
            sourceIds.add((Object)partitionedSource);
        }
        this.sourceIds = sourceIds.build();
        this.outputPartitioning = (OutputPartitioning)((Object)Preconditions.checkNotNull((Object)((Object)outputPartitioning), (Object)"outputPartitioning is null"));
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public PlanDistribution getDistribution() {
        return this.distribution;
    }

    @JsonProperty
    public PlanNodeId getPartitionedSource() {
        return this.partitionedSource;
    }

    @JsonProperty
    public OutputPartitioning getOutputPartitioning() {
        return this.outputPartitioning;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    public List<Integer> getPartitioningChannels() {
        Preconditions.checkState((this.outputPartitioning == OutputPartitioning.HASH ? 1 : 0) != 0, (Object)"fragment is not hash partitioned");
        Preconditions.checkState((boolean)(this.root instanceof SinkNode), (Object)"root is not an instance of SinkNode");
        return IterableTransformer.on(this.partitionBy).transform(new Function<Symbol, Integer>(){

            public Integer apply(Symbol input) {
                return PlanFragment.this.root.getOutputSymbols().indexOf(input);
            }
        }).list();
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public List<PlanNode> getSources() {
        return this.sources;
    }

    public Set<PlanNodeId> getSourceIds() {
        return this.sourceIds;
    }

    private static void findSources(PlanNode node, ImmutableList.Builder<PlanNode> builder, PlanNodeId partitionedSource) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findSources(source, builder, partitionedSource);
        }
        if (node.getSources().isEmpty() || node.getId().equals(partitionedSource)) {
            builder.add((Object)node);
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("distribution", (Object)this.distribution).add("partitionedSource", (Object)this.partitionedSource).add("outputPartitioning", (Object)this.outputPartitioning).toString();
    }

    public static Function<PlanFragment, PlanFragmentId> idGetter() {
        return new Function<PlanFragment, PlanFragmentId>(){

            public PlanFragmentId apply(PlanFragment input) {
                return input.getId();
            }
        };
    }

    public static enum OutputPartitioning {
        NONE,
        HASH;

    }

    public static enum PlanDistribution {
        NONE,
        FIXED,
        SOURCE,
        COORDINATOR_ONLY;

    }
}

