/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;

public class SqlTypeByteCodeExpression
extends ByteCodeExpression {
    private final Type type;
    private final Binding binding;
    private final Method bootstrapMethod;

    public static ByteCodeExpression constantType(CompilerContext context, CallSiteBinder callSiteBinder, Type type) {
        Preconditions.checkNotNull((Object)context, (Object)"context is null");
        Preconditions.checkNotNull((Object)callSiteBinder, (Object)"callSiteBinder is null");
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Binding binding = callSiteBinder.bind(type, Type.class);
        return new SqlTypeByteCodeExpression(type, binding, context.getDefaultBootstrapMethod());
    }

    private SqlTypeByteCodeExpression(Type type, Binding binding, Method bootstrapMethod) {
        super(ParameterizedType.type(Type.class));
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.binding = (Binding)Preconditions.checkNotNull((Object)binding, (Object)"binding is null");
        this.bootstrapMethod = (Method)Preconditions.checkNotNull((Object)bootstrapMethod, (Object)"bootstrapMethod is null");
    }

    @Override
    public ByteCodeNode getByteCode() {
        return InvokeInstruction.invokeDynamic(this.type.getName().replaceAll("\\W+", "_"), this.binding.getType(), this.bootstrapMethod, this.binding.getBindingId());
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    @Override
    protected String formatOneLine() {
        return this.type.getName();
    }
}

