/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.PagesIndexOrdering;
import com.facebook.presto.operator.SimplePagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class OrderingCompiler {
    private static final Logger log = Logger.get(OrderingCompiler.class);
    private final LoadingCache<PagesIndexComparatorCacheKey, PagesIndexOrdering> pagesIndexOrderings = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<PagesIndexComparatorCacheKey, PagesIndexOrdering>(){

        public PagesIndexOrdering load(PagesIndexComparatorCacheKey key) throws Exception {
            return OrderingCompiler.this.internalCompilePagesIndexOrdering(key.getSortTypes(), key.getSortChannels(), key.getSortOrders());
        }
    });

    public PagesIndexOrdering compilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        Preconditions.checkNotNull(sortTypes, (Object)"sortTypes is null");
        Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        try {
            return (PagesIndexOrdering)this.pagesIndexOrderings.get((Object)new PagesIndexComparatorCacheKey(sortTypes, sortChannels, sortOrders));
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    @VisibleForTesting
    public PagesIndexOrdering internalCompilePagesIndexOrdering(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) throws Exception {
        PagesIndexComparator comparator;
        Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        try {
            Class<? extends PagesIndexComparator> pagesHashStrategyClass = this.compilePagesIndexComparator(sortTypes, sortChannels, sortOrders);
            comparator = pagesHashStrategyClass.newInstance();
        }
        catch (Throwable e) {
            log.error(e, "Error compiling comparator for channels %s with order %s", new Object[]{sortChannels, sortChannels});
            comparator = new SimplePagesIndexComparator(sortTypes, sortChannels, sortOrders);
        }
        return new PagesIndexOrdering(comparator);
    }

    private Class<? extends PagesIndexComparator> compilePagesIndexComparator(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("PagesIndexComparator"), ParameterizedType.type(Object.class), ParameterizedType.type(PagesIndexComparator.class));
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        this.generateCompareTo(classDefinition, callSiteBinder, sortTypes, sortChannels, sortOrders);
        return CompilerUtils.defineClass(classDefinition, PagesIndexComparator.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateCompareTo(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        MethodDefinition compareToMethod = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "compareTo", ParameterizedType.type(Integer.TYPE), NamedParameterDefinition.arg("pagesIndex", PagesIndex.class), NamedParameterDefinition.arg("leftPosition", Integer.TYPE), NamedParameterDefinition.arg("rightPosition", Integer.TYPE));
        Variable valueAddresses = context.declareVariable(LongArrayList.class, "valueAddresses");
        compareToMethod.getBody().comment("LongArrayList valueAddresses = pagesIndex.valueAddresses").append(valueAddresses.set(context.getVariable("pagesIndex").invoke("getValueAddresses", LongArrayList.class, new ByteCodeExpression[0])));
        Variable leftPageAddress = context.declareVariable(Long.TYPE, "leftPageAddress");
        compareToMethod.getBody().comment("long leftPageAddress = valueAddresses.getLong(leftPosition)").append(leftPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, context.getVariable("leftPosition"))));
        Variable leftBlockIndex = context.declareVariable(Integer.TYPE, "leftBlockIndex");
        compareToMethod.getBody().comment("int leftBlockIndex = decodeSliceIndex(leftPageAddress)").append(leftBlockIndex.set(ByteCodeExpressions.invokeStatic(SyntheticAddress.class, "decodeSliceIndex", Integer.TYPE, leftPageAddress)));
        Variable leftBlockPosition = context.declareVariable(Integer.TYPE, "leftBlockPosition");
        compareToMethod.getBody().comment("int leftBlockPosition = decodePosition(leftPageAddress)").append(leftBlockPosition.set(ByteCodeExpressions.invokeStatic(SyntheticAddress.class, "decodePosition", Integer.TYPE, leftPageAddress)));
        Variable rightPageAddress = context.declareVariable(Long.TYPE, "rightPageAddress");
        compareToMethod.getBody().comment("long rightPageAddress = valueAddresses.getLong(rightPosition);").append(rightPageAddress.set(valueAddresses.invoke("getLong", Long.TYPE, context.getVariable("rightPosition"))));
        Variable rightBlockIndex = context.declareVariable(Integer.TYPE, "rightBlockIndex");
        compareToMethod.getBody().comment("int rightBlockIndex = decodeSliceIndex(rightPageAddress)").append(rightBlockIndex.set(ByteCodeExpressions.invokeStatic(SyntheticAddress.class, "decodeSliceIndex", Integer.TYPE, rightPageAddress)));
        Variable rightBlockPosition = context.declareVariable(Integer.TYPE, "rightBlockPosition");
        compareToMethod.getBody().comment("int rightBlockPosition = decodePosition(rightPageAddress)").append(rightBlockPosition.set(ByteCodeExpressions.invokeStatic(SyntheticAddress.class, "decodePosition", Integer.TYPE, rightPageAddress)));
        for (int i = 0; i < sortChannels.size(); ++i) {
            int sortChannel = sortChannels.get(i);
            SortOrder sortOrder = sortOrders.get(i);
            com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context).setDescription("compare channel " + sortChannel + " " + sortOrder);
            Type sortType = sortTypes.get(i);
            ByteCodeExpression leftBlock = context.getVariable("pagesIndex").invoke("getChannel", ObjectArrayList.class, ByteCodeExpressions.constantInt(sortChannel)).invoke("get", Object.class, leftBlockIndex).cast(Block.class);
            ByteCodeExpression rightBlock = context.getVariable("pagesIndex").invoke("getChannel", ObjectArrayList.class, ByteCodeExpressions.constantInt(sortChannel)).invoke("get", Object.class, rightBlockIndex).cast(Block.class);
            block.append(ByteCodeExpressions.getStatic(SortOrder.class, sortOrder.name()).invoke("compareBlockValue", (Class<?>)Integer.TYPE, (Iterable<? extends Class<?>>)ImmutableList.of(Type.class, Block.class, Integer.TYPE, Block.class, Integer.TYPE), SqlTypeByteCodeExpression.constantType(context, callSiteBinder, sortType), leftBlock, leftBlockPosition, rightBlock, rightBlockPosition));
            LabelNode equal = new LabelNode("equal");
            block.comment("if (compare != 0) return compare").dup().ifZeroGoto(equal).retInt().visitLabel(equal).pop(Integer.TYPE);
            compareToMethod.getBody().append(block);
        }
        compareToMethod.getBody().push(0).retInt();
    }

    private static final class PagesIndexComparatorCacheKey {
        private final List<Type> sortTypes;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;

        private PagesIndexComparatorCacheKey(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
            this.sortTypes = ImmutableList.copyOf(sortTypes);
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
        }

        public List<Type> getSortTypes() {
            return this.sortTypes;
        }

        public List<Integer> getSortChannels() {
            return this.sortChannels;
        }

        public List<SortOrder> getSortOrders() {
            return this.sortOrders;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.sortTypes, this.sortChannels, this.sortOrders});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PagesIndexComparatorCacheKey other = (PagesIndexComparatorCacheKey)obj;
            return Objects.equal(this.sortTypes, other.sortTypes) && Objects.equal(this.sortChannels, other.sortChannels) && Objects.equal(this.sortOrders, other.sortOrders);
        }
    }
}

