/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupJoinOperator;
import com.facebook.presto.operator.LookupJoinOperatorFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class JoinProbeCompiler {
    private final LoadingCache<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory> joinProbeFactories = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinOperatorCacheKey, HashJoinOperatorFactoryFactory>(){

        public HashJoinOperatorFactoryFactory load(JoinOperatorCacheKey key) throws Exception {
            return JoinProbeCompiler.this.internalCompileJoinOperatorFactory(key.getTypes(), key.getProbeChannels());
        }
    });

    public OperatorFactory compileJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, boolean enableOuterJoin) {
        try {
            HashJoinOperatorFactoryFactory operatorFactoryFactory = (HashJoinOperatorFactoryFactory)this.joinProbeFactories.get((Object)new JoinOperatorCacheKey(probeTypes, probeJoinChannel, enableOuterJoin));
            return operatorFactoryFactory.createHashJoinOperatorFactory(operatorId, lookupSourceSupplier, probeTypes, probeJoinChannel, enableOuterJoin);
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    public HashJoinOperatorFactoryFactory internalCompileJoinOperatorFactory(List<Type> types, List<Integer> probeJoinChannel) {
        JoinProbeFactory joinProbeFactory;
        Class<? extends JoinProbe> joinProbeClass = this.compileJoinProbe(types, probeJoinChannel);
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("JoinProbeFactory"), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbeFactory.class));
        classDefinition.declareDefaultConstructor(Access.a(Access.PUBLIC));
        classDefinition.declareMethod(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC), "createJoinProbe", ParameterizedType.type(JoinProbe.class), NamedParameterDefinition.arg("lookupSource", LookupSource.class), NamedParameterDefinition.arg("page", Page.class)).getBody().newObject(joinProbeClass).dup().getVariable("lookupSource").getVariable("page").invokeConstructor(joinProbeClass, LookupSource.class, Page.class).retObject();
        DynamicClassLoader classLoader = new DynamicClassLoader(joinProbeClass.getClassLoader());
        Class<JoinProbeFactory> joinProbeFactoryClass = CompilerUtils.defineClass(classDefinition, JoinProbeFactory.class, classLoader);
        try {
            joinProbeFactory = joinProbeFactoryClass.newInstance();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Class<LookupJoinOperatorFactory> operatorFactoryClass = IsolatedClass.isolateClass(classLoader, OperatorFactory.class, LookupJoinOperatorFactory.class, LookupJoinOperator.class);
        return new HashJoinOperatorFactoryFactory(joinProbeFactory, operatorFactoryClass);
    }

    @VisibleForTesting
    public JoinProbeFactory internalCompileJoinProbe(List<Type> types, List<Integer> probeChannels) {
        return new ReflectionJoinProbeFactory(this.compileJoinProbe(types, probeChannels));
    }

    private Class<? extends JoinProbe> compileJoinProbe(List<Type> types, List<Integer> probeChannels) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName("JoinProbe"), ParameterizedType.type(Object.class), ParameterizedType.type(JoinProbe.class));
        FieldDefinition lookupSourceField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "lookupSource", LookupSource.class);
        FieldDefinition positionCountField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "positionCount", Integer.TYPE);
        ArrayList<FieldDefinition> blockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < types.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "block_" + i, Block.class);
            blockFields.add(channelField);
        }
        ArrayList<FieldDefinition> probeBlockFields = new ArrayList<FieldDefinition>();
        for (int i = 0; i < probeChannels.size(); ++i) {
            FieldDefinition channelField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeBlock_" + i, Block.class);
            probeBlockFields.add(channelField);
        }
        FieldDefinition probeBlocksArrayField = classDefinition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "probeBlocks", Block[].class);
        FieldDefinition positionField = classDefinition.declareField(Access.a(Access.PRIVATE), "position", Integer.TYPE);
        this.generateConstructor(classDefinition, probeChannels, lookupSourceField, blockFields, probeBlockFields, probeBlocksArrayField, positionField, positionCountField);
        this.generateGetChannelCountMethod(classDefinition, blockFields.size());
        this.generateAppendToMethod(classDefinition, callSiteBinder, types, blockFields, positionField);
        this.generateAdvanceNextPosition(classDefinition, positionField, positionCountField);
        this.generateGetCurrentJoinPosition(classDefinition, lookupSourceField, probeBlocksArrayField, positionField);
        this.generateCurrentRowContainsNull(classDefinition, probeBlockFields, positionField);
        return CompilerUtils.defineClass(classDefinition, JoinProbe.class, callSiteBinder.getBindings(), this.getClass().getClassLoader());
    }

    private void generateConstructor(ClassDefinition classDefinition, List<Integer> probeChannels, FieldDefinition lookupSourceField, List<FieldDefinition> blockFields, List<FieldDefinition> probeChannelFields, FieldDefinition probeBlocksArrayField, FieldDefinition positionField, FieldDefinition positionCountField) {
        int index;
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block constructor = classDefinition.declareConstructor(context, Access.a(Access.PUBLIC), NamedParameterDefinition.arg("lookupSource", LookupSource.class), NamedParameterDefinition.arg("page", Page.class)).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]);
        constructor.comment("this.lookupSource = lookupSource;").append(context.getVariable("this").setField(lookupSourceField, (ByteCodeExpression)context.getVariable("lookupSource")));
        constructor.comment("this.positionCount = page.getPositionCount();").append(context.getVariable("this").setField(positionCountField, context.getVariable("page").invoke("getPositionCount", Integer.TYPE, new ByteCodeExpression[0])));
        constructor.comment("Set block fields");
        for (index = 0; index < blockFields.size(); ++index) {
            constructor.append(context.getVariable("this").setField(blockFields.get(index), context.getVariable("page").invoke("getBlock", Block.class, ByteCodeExpressions.constantInt(index))));
        }
        constructor.comment("Set probe channel fields");
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.append(context.getVariable("this").setField(probeChannelFields.get(index), context.getVariable("this").getField(blockFields.get(probeChannels.get(index)))));
        }
        constructor.comment("this.probeBlocks = new Block[<probeChannelCount>];");
        constructor.pushThis().push(probeChannelFields.size()).newArray(Block.class).putField(probeBlocksArrayField);
        for (index = 0; index < probeChannelFields.size(); ++index) {
            constructor.pushThis().getField(probeBlocksArrayField).push(index).pushThis().getField(probeChannelFields.get(index)).putObjectArrayElement();
        }
        constructor.comment("this.position = -1;").append(context.getVariable("this").setField(positionField, ByteCodeExpressions.constantInt(-1)));
        constructor.ret();
    }

    private void generateGetChannelCountMethod(ClassDefinition classDefinition, int channelCount) {
        classDefinition.declareMethod(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), Access.a(Access.PUBLIC), "getChannelCount", ParameterizedType.type(Integer.TYPE), new NamedParameterDefinition[0]).getBody().push(channelCount).retInt();
    }

    private void generateAppendToMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, List<Type> types, List<FieldDefinition> blockFields, FieldDefinition positionField) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block appendToBody = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "appendTo", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("pageBuilder", PageBuilder.class)).getBody();
        for (int index = 0; index < blockFields.size(); ++index) {
            Type type = types.get(index);
            appendToBody.comment("%s.appendTo(block_%s, position, pageBuilder.getBlockBuilder(%s));", type.getClass(), index, index).append(SqlTypeByteCodeExpression.constantType(context, callSiteBinder, type).invoke("appendTo", Void.TYPE, context.getVariable("this").getField(blockFields.get(index)), context.getVariable("this").getField(positionField), context.getVariable("pageBuilder").invoke("getBlockBuilder", BlockBuilder.class, ByteCodeExpressions.constantInt(index))));
        }
        appendToBody.ret();
    }

    private void generateAdvanceNextPosition(ClassDefinition classDefinition, FieldDefinition positionField, FieldDefinition positionCountField) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block advanceNextPositionBody = classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "advanceNextPosition", ParameterizedType.type(Boolean.TYPE), new NamedParameterDefinition[0]).getBody();
        advanceNextPositionBody.comment("this.position = this.position + 1;").pushThis().pushThis().getField(positionField).push(1).intAdd().putField(positionField);
        LabelNode lessThan = new LabelNode("lessThan");
        LabelNode end = new LabelNode("end");
        advanceNextPositionBody.comment("return position < positionCount;").pushThis().getField(positionField).pushThis().getField(positionCountField).append(JumpInstruction.jumpIfIntLessThan(lessThan)).push(false).gotoLabel(end).visitLabel(lessThan).push(true).visitLabel(end).retBoolean();
    }

    private void generateGetCurrentJoinPosition(ClassDefinition classDefinition, FieldDefinition lookupSourceField, FieldDefinition probeBlockArrayField, FieldDefinition positionField) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        classDefinition.declareMethod(context, Access.a(Access.PUBLIC), "getCurrentJoinPosition", ParameterizedType.type(Long.TYPE), new NamedParameterDefinition[0]).getBody().append(new IfStatement(context, new com.facebook.presto.byteCode.Block(context).append(context.getVariable("this").invoke("currentRowContainsNull", Boolean.TYPE, new ByteCodeExpression[0])), new com.facebook.presto.byteCode.Block(context).push(-1L).retLong(), null)).append(context.getVariable("this").getField(lookupSourceField).invoke("getJoinPosition", Long.TYPE, context.getVariable("this").getField(positionField), context.getVariable("this").getField(probeBlockArrayField))).retLong();
    }

    private void generateCurrentRowContainsNull(ClassDefinition classDefinition, List<FieldDefinition> probeBlockFields, FieldDefinition positionField) {
        CompilerContext context = new CompilerContext(Bootstrap.BOOTSTRAP_METHOD);
        com.facebook.presto.byteCode.Block body = classDefinition.declareMethod(context, Access.a(Access.PRIVATE), "currentRowContainsNull", ParameterizedType.type(Boolean.TYPE), new NamedParameterDefinition[0]).getBody();
        for (FieldDefinition probeBlockField : probeBlockFields) {
            LabelNode checkNextField = new LabelNode("checkNextField");
            body.append(context.getVariable("this").getField(probeBlockField).invoke("isNull", Boolean.TYPE, context.getVariable("this").getField(positionField))).ifFalseGoto(checkNextField).push(true).retBoolean().visitLabel(checkNextField);
        }
        body.push(false).retInt();
    }

    public static void checkState(boolean left, boolean right) {
        if (left != right) {
            throw new IllegalStateException();
        }
    }

    private static class HashJoinOperatorFactoryFactory {
        private final JoinProbeFactory joinProbeFactory;
        private final Constructor<? extends OperatorFactory> constructor;

        private HashJoinOperatorFactoryFactory(JoinProbeFactory joinProbeFactory, Class<? extends OperatorFactory> operatorFactoryClass) {
            this.joinProbeFactory = joinProbeFactory;
            try {
                this.constructor = operatorFactoryClass.getConstructor(Integer.TYPE, LookupSourceSupplier.class, List.class, Boolean.TYPE, JoinProbeFactory.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public OperatorFactory createHashJoinOperatorFactory(int operatorId, LookupSourceSupplier lookupSourceSupplier, List<? extends Type> probeTypes, List<Integer> probeJoinChannel, boolean enableOuterJoin) {
            try {
                return this.constructor.newInstance(operatorId, lookupSourceSupplier, probeTypes, enableOuterJoin, this.joinProbeFactory);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class JoinOperatorCacheKey {
        private final List<Type> types;
        private final List<Integer> probeChannels;
        private final boolean enableOuterJoin;

        private JoinOperatorCacheKey(List<? extends Type> types, List<Integer> probeChannels, boolean enableOuterJoin) {
            this.types = ImmutableList.copyOf(types);
            this.probeChannels = ImmutableList.copyOf(probeChannels);
            this.enableOuterJoin = enableOuterJoin;
        }

        private List<Type> getTypes() {
            return this.types;
        }

        private List<Integer> getProbeChannels() {
            return this.probeChannels;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.types, this.probeChannels, this.enableOuterJoin});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JoinOperatorCacheKey)) {
                return false;
            }
            JoinOperatorCacheKey other = (JoinOperatorCacheKey)obj;
            return Objects.equal(this.types, other.types) && Objects.equal(this.probeChannels, other.probeChannels) && Objects.equal((Object)this.enableOuterJoin, (Object)other.enableOuterJoin);
        }
    }

    public static class ReflectionJoinProbeFactory
    implements JoinProbeFactory {
        private final Constructor<? extends JoinProbe> constructor;

        public ReflectionJoinProbeFactory(Class<? extends JoinProbe> joinProbeClass) {
            try {
                this.constructor = joinProbeClass.getConstructor(LookupSource.class, Page.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            try {
                return this.constructor.newInstance(lookupSource, page);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

