/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.ByteCodeGenerator;
import com.facebook.presto.sql.gen.ByteCodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class CoalesceCodeGenerator
implements ByteCodeGenerator {
    @Override
    public ByteCodeNode generateExpression(Signature signature, ByteCodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ArrayList<ByteCodeNode> operands = new ArrayList<ByteCodeNode>();
        for (RowExpression expression : arguments) {
            operands.add(generatorContext.generate(expression));
        }
        CompilerContext context = generatorContext.getContext();
        ByteCodeNode nullValue = new Block(context).putVariable("wasNull", true).pushJavaDefault(returnType.getJavaType());
        for (ByteCodeNode operand : Lists.reverse(operands)) {
            Block condition = new Block(context).append(operand).getVariable("wasNull");
            Block nullBlock = new Block(context).pop(returnType.getJavaType()).putVariable("wasNull", false).append(nullValue);
            nullValue = new IfStatement(context, condition, nullBlock, OpCode.NOP);
        }
        return nullValue;
    }
}

