/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.server.ForAsyncHttpResponse;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.spi.Page;
import com.facebook.presto.util.MoreFutures;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.server.AsyncResponseHandler;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/task")
public class TaskResource {
    private static final DataSize DEFAULT_MAX_SIZE = new DataSize(10.0, DataSize.Unit.MEGABYTE);
    private static final Duration DEFAULT_MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private final TaskManager taskManager;
    private final ScheduledExecutorService executor;

    @Inject
    public TaskResource(TaskManager taskManager, @ForAsyncHttpResponse ScheduledExecutorService executor) {
        this.taskManager = (TaskManager)Preconditions.checkNotNull((Object)taskManager, (Object)"taskManager is null");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
    }

    @GET
    @Produces(value={"application/json"})
    public List<TaskInfo> getAllTaskInfo(@Context UriInfo uriInfo) {
        ImmutableList allTaskInfo = this.taskManager.getAllTaskInfo();
        if (TaskResource.shouldSummarize(uriInfo)) {
            allTaskInfo = ImmutableList.copyOf((Iterable)Iterables.transform(allTaskInfo, TaskInfo.summarizeTaskInfo()));
        }
        return allTaskInfo;
    }

    @POST
    @Path(value="{taskId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createOrUpdateTask(@PathParam(value="taskId") TaskId taskId, TaskUpdateRequest taskUpdateRequest, @Context UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)taskUpdateRequest, (Object)"taskUpdateRequest is null");
        TaskInfo taskInfo = this.taskManager.updateTask(taskUpdateRequest.getSession(), taskId, taskUpdateRequest.getFragment(), taskUpdateRequest.getSources(), taskUpdateRequest.getOutputIds());
        if (TaskResource.shouldSummarize(uriInfo)) {
            taskInfo = taskInfo.summarize();
        }
        return Response.ok().entity((Object)taskInfo).build();
    }

    @GET
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public void getTaskInfo(final @PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-State") TaskState currentState, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        if (currentState == null || maxWait == null) {
            asyncResponse.resume((Object)this.taskManager.getTaskInfo(taskId));
            return;
        }
        ListenableFuture futureTaskInfo = MoreFutures.addTimeout(this.taskManager.getTaskInfo(taskId, currentState), new Callable<TaskInfo>(){

            @Override
            public TaskInfo call() {
                return TaskResource.this.taskManager.getTaskInfo(taskId);
            }
        }, maxWait, this.executor);
        if (TaskResource.shouldSummarize(uriInfo)) {
            futureTaskInfo = Futures.transform(futureTaskInfo, (Function)new Function<TaskInfo, TaskInfo>(){

                public TaskInfo apply(TaskInfo taskInfo) {
                    return taskInfo.summarize();
                }
            });
        }
        Duration timeout = new Duration((double)(maxWait.toMillis() + 5000L), TimeUnit.MILLISECONDS);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)futureTaskInfo, (Executor)this.executor).withTimeout(timeout);
    }

    @DELETE
    @Path(value="{taskId}")
    @Produces(value={"application/json"})
    public Response cancelTask(@PathParam(value="taskId") TaskId taskId, @Context UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        TaskInfo taskInfo = this.taskManager.cancelTask(taskId);
        if (TaskResource.shouldSummarize(uriInfo)) {
            taskInfo = taskInfo.summarize();
        }
        return Response.ok((Object)taskInfo).build();
    }

    @GET
    @Path(value="{taskId}/results/{outputId}/{token}")
    @Produces(value={"application/X-presto-pages"})
    public void getResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="outputId") TaskId outputId, final @PathParam(value="token") long token, @Suspended AsyncResponse asyncResponse) throws InterruptedException {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        ListenableFuture<BufferResult> bufferResultFuture = this.taskManager.getTaskResults(taskId, outputId, token, DEFAULT_MAX_SIZE);
        bufferResultFuture = MoreFutures.addTimeout(bufferResultFuture, new Callable<BufferResult>(){

            @Override
            public BufferResult call() {
                return BufferResult.emptyResults(token, false);
            }
        }, DEFAULT_MAX_WAIT_TIME, this.executor);
        ListenableFuture responseFuture = Futures.transform(bufferResultFuture, (Function)new Function<BufferResult, Response>(){

            public Response apply(BufferResult result) {
                Response.Status status;
                List<Page> pages = result.getPages();
                GenericEntity entity = null;
                if (!pages.isEmpty()) {
                    entity = new GenericEntity(pages, new TypeToken<List<Page>>(){}.getType());
                    status = Response.Status.OK;
                } else {
                    status = result.isBufferClosed() ? Response.Status.GONE : Response.Status.NO_CONTENT;
                }
                return Response.status((Response.Status)status).entity(entity).header("X-Presto-Page-Sequence-Id", (Object)result.getToken()).header("X-Presto-Page-End-Sequence-Id", (Object)result.getNextToken()).build();
            }
        });
        Duration timeout = new Duration((double)(DEFAULT_MAX_WAIT_TIME.toMillis() + 5000L), TimeUnit.MILLISECONDS);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)responseFuture, (Executor)this.executor).withTimeout(timeout, Response.status((Response.Status)Response.Status.NO_CONTENT).header("X-Presto-Page-Sequence-Id", (Object)token).header("X-Presto-Page-End-Sequence-Id", (Object)token).build());
    }

    @DELETE
    @Path(value="{taskId}/results/{outputId}")
    @Produces(value={"application/json"})
    public Response abortResults(@PathParam(value="taskId") TaskId taskId, @PathParam(value="outputId") TaskId outputId, @Context UriInfo uriInfo) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        TaskInfo taskInfo = this.taskManager.abortTaskResults(taskId, outputId);
        if (TaskResource.shouldSummarize(uriInfo)) {
            taskInfo = taskInfo.summarize();
        }
        return Response.ok((Object)taskInfo).build();
    }

    private static boolean shouldSummarize(UriInfo uriInfo) {
        return uriInfo.getQueryParameters().containsKey((Object)"summarize");
    }
}

