/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.block.dictionary.DictionaryBlockEncoding;
import com.facebook.presto.block.rle.RunLengthBlockEncoding;
import com.facebook.presto.block.snappy.SnappyBlockEncoding;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.informationSchema.InformationSchemaModule;
import com.facebook.presto.connector.jmx.JmxConnectorFactory;
import com.facebook.presto.connector.system.SystemTablesModule;
import com.facebook.presto.event.query.QueryCompletionEvent;
import com.facebook.presto.event.query.QueryCreatedEvent;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.event.query.SplitCompletionEvent;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.guice.AbstractConfigurationAwareModule;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogManagerConfig;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.NodeVersion;
import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientFactory;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.operator.ForScheduler;
import com.facebook.presto.operator.RecordSinkManager;
import com.facebook.presto.operator.RecordSinkProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.server.CoordinatorModule;
import com.facebook.presto.server.ExecuteResource;
import com.facebook.presto.server.ForAsyncHttpResponse;
import com.facebook.presto.server.ForExecute;
import com.facebook.presto.server.HttpLocationFactory;
import com.facebook.presto.server.HttpRemoteTaskFactory;
import com.facebook.presto.server.NodeResource;
import com.facebook.presto.server.PagesResponseWriter;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.PrestoServer;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.SliceDeserializer;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.server.StatementResource;
import com.facebook.presto.server.TaskResource;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.ThreadResource;
import com.facebook.presto.server.ThrowableMapper;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.FixedWidthBlockEncoding;
import com.facebook.presto.spi.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.spi.block.SliceArrayBlockEncoding;
import com.facebook.presto.spi.block.VariableWidthBlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.event.client.EventBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class ServerMainModule
extends AbstractConfigurationAwareModule {
    private final SqlParserOptions sqlParserOptions;

    public ServerMainModule(SqlParserOptions sqlParserOptions) {
        this.sqlParserOptions = (SqlParserOptions)Preconditions.checkNotNull((Object)sqlParserOptions, (Object)"sqlParserOptions is null");
    }

    @Override
    protected void setup(Binder binder) {
        ServerConfig serverConfig = this.buildConfigObject(ServerConfig.class);
        binder.install((Module)new CoordinatorModule());
        if (serverConfig.isCoordinator()) {
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-coordinator");
        }
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        binder.bind(SqlParserOptions.class).toInstance((Object)this.sqlParserOptions);
        ServerMainModule.bindFailureDetector(binder, serverConfig.isCoordinator());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThrowableMapper.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskResource.class);
        binder.bind(TaskManager.class).to(SqlTaskManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskManager.class).withGeneratedName();
        binder.bind(TaskExecutor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutor.class).withGeneratedName();
        binder.bind(LocalExecutionPlanner.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(CompilerConfig.class);
        binder.bind(ExpressionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExpressionCompiler.class).withGeneratedName();
        ConfigurationModule.bindConfig((Binder)binder).to(TaskManagerConfig.class);
        binder.bind(IndexJoinLookupStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IndexJoinLookupStats.class).withGeneratedName();
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(PagesResponseWriter.class);
        binder.bind((TypeLiteral)new TypeLiteral<Supplier<ExchangeClient>>(){}).to(ExchangeClientFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("exchange", ForExchange.class).withTracing();
        ConfigurationModule.bindConfig((Binder)binder).to(ExchangeClientConfig.class);
        binder.bind(LocationFactory.class).to(HttpLocationFactory.class).in(Scopes.SINGLETON);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing();
        binder.bind(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSourceProvider.class).to(PageSourceManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorPageSourceProvider.class);
        binder.bind(RecordSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(RecordSinkProvider.class).to(RecordSinkManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorRecordSinkProvider.class);
        binder.bind(CatalogManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(CatalogManagerConfig.class);
        binder.bind(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).to(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(TypeRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).to(TypeRegistry.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        Multibinder.newSetBinder((Binder)binder, Type.class);
        binder.bind(IndexManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.bind(ConnectorManager.class).in(Scopes.SINGLETON);
        MapBinder connectorFactoryBinder = MapBinder.newMapBinder((Binder)binder, String.class, ConnectorFactory.class);
        connectorFactoryBinder.addBinding((Object)"jmx").to(JmxConnectorFactory.class);
        binder.install((Module)new InformationSchemaModule());
        binder.install((Module)new SystemTablesModule());
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ConnectorSplit.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(Serialization.ExpressionSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(Serialization.ExpressionDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(FunctionCall.class).to(Serialization.FunctionCallDeserializer.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCreatedEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCompletionEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{SplitCompletionEvent.class});
        String prestoVersion = serverConfig.getPrestoVersion();
        if (prestoVersion == null) {
            prestoVersion = ServerMainModule.detectPrestoVersion();
        }
        Preconditions.checkState((prestoVersion != null ? 1 : 0) != 0, (Object)"presto.version must be provided when it cannot be automatically determined");
        NodeVersion nodeVersion = new NodeVersion(prestoVersion);
        binder.bind(NodeVersion.class).toInstance((Object)nodeVersion);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto").addProperty("node_version", nodeVersion.toString()).addProperty("datasources", Strings.nullToEmpty((String)serverConfig.getDataSources()));
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StatementResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ExecuteResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("execute", ForExecute.class);
        binder.bind(PluginManager.class).in(Scopes.SINGLETON);
        ConfigurationModule.bindConfig((Binder)binder).to(PluginManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<PlanOptimizer>>(){}).toProvider(PlanOptimizersFactory.class).in(Scopes.SINGLETON);
        binder.bind(BlockEncodingManager.class).in(Scopes.SINGLETON);
        binder.bind(BlockEncodingSerde.class).to(BlockEncodingManager.class).in(Scopes.SINGLETON);
        Multibinder blockEncodingFactoryBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<BlockEncodingFactory<?>>(){});
        blockEncodingFactoryBinder.addBinding().toInstance((Object)VariableWidthBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance((Object)FixedWidthBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance(RunLengthBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance(DictionaryBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance(SnappyBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance((Object)SliceArrayBlockEncoding.FACTORY);
        blockEncodingFactoryBinder.addBinding().toInstance((Object)LazySliceArrayBlockEncoding.FACTORY);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThreadResource.class);
    }

    @Provides
    @Singleton
    @ForExchange
    public ScheduledExecutorService createExchangeExecutor() {
        return Executors.newScheduledThreadPool(4, Threads.daemonThreadsNamed((String)"exchange-client-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttpResponse
    public static ScheduledExecutorService createAsyncHttpResponseExecutor() {
        return Executors.newScheduledThreadPool(10, Threads.daemonThreadsNamed((String)"async-http-response-%s"));
    }

    private static String detectPrestoVersion() {
        String title = PrestoServer.class.getPackage().getImplementationTitle();
        String version = PrestoServer.class.getPackage().getImplementationVersion();
        return title == null || version == null ? null : title + ":" + version;
    }

    private static void bindFailureDetector(Binder binder, boolean coordinator) {
        if (coordinator) {
            binder.install((Module)new FailureDetectorModule());
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        } else {
            binder.bind(FailureDetector.class).toInstance((Object)new FailureDetector(){

                @Override
                public Set<ServiceDescriptor> getFailed() {
                    return ImmutableSet.of();
                }
            });
        }
    }
}

