/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import java.nio.ByteOrder;

final class PrestoJvmRequirements {
    private PrestoJvmRequirements() {
    }

    public static void verifyJvmRequirements() {
        String version;
        String vendor;
        String specVersion = StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value();
        if (specVersion.compareTo("1.7") < 0) {
            PrestoJvmRequirements.failRequirement("Presto requires Java 1.7+ (found %s)", specVersion);
        }
        if (!(vendor = StandardSystemProperty.JAVA_VENDOR.value()).equals("Oracle Corporation")) {
            PrestoJvmRequirements.failRequirement("Presto requires an Oracle or OpenJDK JVM (found %s)", vendor);
        }
        if (PrestoJvmRequirements.jdkVersion(version = StandardSystemProperty.JAVA_VERSION.value()).equals("1.7.0") && PrestoJvmRequirements.jdkUpdate(version).compareTo("06") < 0) {
            PrestoJvmRequirements.failRequirement("Presto requires Oracle JDK 7u6+ (found %s)", version);
        }
        String osName = StandardSystemProperty.OS_NAME.value();
        String osArch = StandardSystemProperty.OS_ARCH.value();
        switch (osName) {
            case "Linux": {
                if (osArch.equals("amd64")) break;
                PrestoJvmRequirements.failRequirement("Presto requires architecture amd64 on Linux (found %s)", osArch);
                break;
            }
            case "Mac OS X": {
                if (osArch.equals("x86_64")) break;
                PrestoJvmRequirements.failRequirement("Presto requires architecture x86_64 on Mac OS X (found %s)", osArch);
                break;
            }
            default: {
                PrestoJvmRequirements.failRequirement("Presto requires Linux or Mac OS X (found %s)", osName);
            }
        }
        if (!ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            PrestoJvmRequirements.failRequirement("Presto requires a little endian platform (found %s)", ByteOrder.nativeOrder());
        }
    }

    private static void failRequirement(String format, Object ... args) {
        System.err.println(String.format(format, args));
        System.exit(100);
    }

    private static String jdkVersion(String version) {
        return (String)Splitter.on((char)'_').split((CharSequence)version).iterator().next();
    }

    private static String jdkUpdate(String version) {
        return (String)Iterables.get((Iterable)Splitter.on((char)'_').split((CharSequence)version), (int)1, (Object)"");
    }
}

