/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class UncompressedEncoder
implements Encoder {
    private final Type type;
    private final SliceOutput sliceOutput;
    private final BlockEncoding encoding;
    private BlockBuilder blockBuilder;
    private boolean finished;

    public UncompressedEncoder(Type type, SliceOutput sliceOutput) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
        this.blockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
        this.encoding = this.blockBuilder.getEncoding();
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.type.appendTo(block, position, this.blockBuilder);
            if (!this.blockBuilder.isFull()) continue;
            this.writeBlock();
        }
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (!this.blockBuilder.isEmpty()) {
            this.writeBlock();
        }
        return this.encoding;
    }

    private void writeBlock() {
        Block block = this.blockBuilder.build();
        this.encoding.writeBlock(this.sliceOutput, block);
        this.blockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
    }
}

