/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.snappy.SnappyBlock;
import com.facebook.presto.block.snappy.SnappyBlockEncoding;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class SnappyEncoder
implements Encoder {
    private final Type type;
    private final SliceOutput sliceOutput;
    private SnappyBlockEncoding encoding;
    private BlockBuilder blockBuilder;
    private boolean finished;

    public SnappyEncoder(Type type, SliceOutput sliceOutput) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        if (this.encoding == null) {
            this.encoding = new SnappyBlockEncoding(block.getEncoding());
            this.blockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            this.type.appendTo(block, position, this.blockBuilder);
            if (!this.blockBuilder.isFull()) continue;
            this.flushBlock();
        }
        return this;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (!this.blockBuilder.isEmpty()) {
            this.flushBlock();
        }
        return this.encoding;
    }

    private void flushBlock() {
        SnappyBlock snappyBlock = new SnappyBlock(this.blockBuilder.build());
        this.encoding.writeBlock(this.sliceOutput, snappyBlock);
        this.blockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
    }
}

