/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import com.facebook.presto.block.rle.RunLengthBlockEncoding;
import com.facebook.presto.block.rle.RunLengthEncodedBlock;
import com.facebook.presto.serde.Encoder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;

public class RunLengthEncoder
implements Encoder {
    private final Type type;
    private final SliceOutput sliceOutput;
    private boolean finished;
    private int positionCount;
    private Block lastValue;
    private RunLengthBlockEncoding encoding;

    public RunLengthEncoder(SliceOutput sliceOutput, Type type) {
        this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.sliceOutput = (SliceOutput)Preconditions.checkNotNull((Object)sliceOutput, (Object)"sliceOutput is null");
    }

    @Override
    public Encoder append(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        if (this.encoding == null) {
            this.encoding = new RunLengthBlockEncoding(block.getEncoding());
        }
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (this.lastValue == null) {
                this.lastValue = block.getSingleValueBlock(position);
            } else if (!TypeUtils.positionEqualsPosition(this.type, this.lastValue, 0, block, position)) {
                this.writeBlock();
                this.lastValue = block.getSingleValueBlock(position);
            }
            ++this.positionCount;
        }
        return this;
    }

    private void writeBlock() {
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(this.lastValue, this.positionCount);
        this.encoding.writeBlock(this.sliceOutput, block);
        this.lastValue = null;
        this.positionCount = 0;
    }

    @Override
    public BlockEncoding finish() {
        Preconditions.checkState((this.encoding != null ? 1 : 0) != 0, (Object)"nothing appended");
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
        this.finished = true;
        if (this.positionCount > 0) {
            this.writeBlock();
        }
        return this.encoding;
    }
}

