/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.serde;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class BlocksFileStats {
    private final long rowCount;
    private final long runsCount;
    private final long avgRunLength;
    private final int uniqueCount;

    public BlocksFileStats(long rowCount, long runsCount, long avgRunLength, int uniqueCount) {
        this.rowCount = rowCount;
        this.runsCount = runsCount;
        this.avgRunLength = avgRunLength;
        this.uniqueCount = uniqueCount;
    }

    public static void serialize(BlocksFileStats stats, SliceOutput sliceOutput) {
        sliceOutput.appendLong(stats.getRowCount()).appendLong(stats.getRunsCount()).appendLong(stats.getAvgRunLength()).appendInt(stats.getUniqueCount());
    }

    public static BlocksFileStats deserialize(Slice slice) {
        BasicSliceInput input = slice.getInput();
        return BlocksFileStats.deserialize((SliceInput)input);
    }

    public static BlocksFileStats deserialize(SliceInput input) {
        long rowCount = input.readLong();
        long runsCount = input.readLong();
        long avgRunLength = input.readLong();
        int uniqueCount = input.readInt();
        return new BlocksFileStats(rowCount, runsCount, avgRunLength, uniqueCount);
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getRunsCount() {
        return this.runsCount;
    }

    public long getAvgRunLength() {
        return this.avgRunLength;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }
}

